package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// GetSquadByID returns the squad, including its members, for the given squad ID, if it exists.
func (b *backend) GetSquadByID(ctx context.Context, id string) (*models.Squad, error) {
	squad := b.getCachedSquadByID(ctx, id)
	if squad != nil {
		return squad, nil
	}

	dbSquad, err := b.Datastore.GetSquadByID(ctx, id)
	if err != nil {
		return nil, err
	}

	if dbSquad == nil {
		return nil, nil
	}

	members, err := b.Datastore.GetMembersBySquadID(ctx, dbSquad.ID)
	if err != nil {
		return nil, err
	}

	squad = models.NewSquadFromDB(dbSquad, members)
	b.cacheSquad(ctx, squad)
	return squad, nil
}
