package backend

import (
	"context"
	"sync"

	service_common "code.justin.tv/feeds/service-common"
	"code.justin.tv/twitch-events/meepo/internal/models"
)

func (b *backend) isInNetwork(ctx context.Context, sourceID, targetID string) (bool, error) {
	isInNetworks := make([]bool, 3)
	errs := make([]error, 3)

	var wg sync.WaitGroup
	wg.Add(3)

	go func() {
		isFollowing, err := b.Follows.IsFollowing(ctx, sourceID, targetID)
		isInNetworks[0] = isFollowing
		errs[0] = err
		wg.Done()
	}()

	go func() {
		isFriend, err := b.Friendship.IsFriend(ctx, sourceID, targetID)
		isInNetworks[1] = isFriend
		errs[1] = err
		wg.Done()
	}()

	go func() {
		isTeammate, err := b.Roster.IsTeammate(ctx, sourceID, targetID)
		isInNetworks[2] = isTeammate
		errs[2] = err
		wg.Done()
	}()

	wg.Wait()

	isInNetwork := false
	for _, result := range isInNetworks {
		if result {
			isInNetwork = true
			break
		}
	}

	return isInNetwork, service_common.ConsolidateErrors(errs)
}

func (b *backend) areInNetworkInvitations(ctx context.Context, dbInvitations []*models.DBInvitation) ([]bool, []error) {
	isInNetworks := make([]bool, len(dbInvitations))
	networkErrs := make([]error, len(dbInvitations))
	var wg sync.WaitGroup
	wg.Add(len(dbInvitations))
	for idx, dbInvitation := range dbInvitations {
		go func(dbInvitation *models.DBInvitation, idx int) {
			isInNetworks[idx], networkErrs[idx] = b.isInNetwork(ctx, dbInvitation.RecipientID, dbInvitation.SenderID)
			wg.Done()
		}(dbInvitation, idx)
	}

	wg.Wait()

	return isInNetworks, networkErrs
}
