package backend

import (
	"context"

	pdms "code.justin.tv/amzn/PDMSLambdaTwirp"
	"code.justin.tv/eventbus/schema/pkg/user"
	"code.justin.tv/vod/eventbus"
	"github.com/golang/protobuf/ptypes/wrappers"
)

// ProcessUserDestroy removes the channel from its current squad, deletes pending and rejected incoming invitations, and
// removes all user preference data related to squad stream.
func (b *backend) ProcessUserDestroy(ctx context.Context, event *user.UserDestroy, cursor *wrappers.StringValue) (*eventbus.ConsumeEventResponse, error) {
	err := b.Datastore.HardDeleteInvitePolicyByChannelID(ctx, event.GetUserId())
	if err != nil {
		return nil, err
	}
	err = b.DeleteUser(ctx, event.GetUserId())
	if err != nil {
		return nil, err
	}

	report := &pdms.ReportDeletionRequest{
		UserId:    event.GetUserId(),
		ServiceId: "387",
	}
	_, err = b.PDMS.ReportDeletion(ctx, report)
	if err != nil {
		return nil, err
	}
	return &eventbus.ConsumeEventResponse{}, nil
}
