package clock

import (
	"time"
)

// Clock is an interface that allows us to control the implementation of Now()
type Clock interface {
	Now() time.Time
	Since(t time.Time) time.Duration
}

// RealClock is a struct wrapper around the clock provided by golang's time package
type RealClock struct{}

// Now returns the time provided by time.Now()
func (r *RealClock) Now() time.Time {
	return time.Now()
}

// Since returns the duration since the time returned by Now()
func (r *RealClock) Since(t time.Time) time.Duration {
	return r.Now().Sub(t)
}
