package mocks

import context "context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"

// UsersClient is an mock type for the UsersClient type
type UsersClient struct {
	mock.Mock
}

// GetUserByID provides a mock function with given fields: ctx, userID
func (_m *UsersClient) GetUserByID(ctx context.Context, userID string) (*models.Properties, error) {
	ret := _m.Called(ctx, userID)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string) *models.Properties); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

func (_m *UsersClient) GetUsersByIDs(ctx context.Context, userIDs []string) ([]*models.Properties, error) {
	properties := make([]*models.Properties, len(userIDs))

	for i, userID := range userIDs {
		userLogin := "user" + userID
		properties[i] = &models.Properties{
			ID:           userID,
			Login:        &userLogin,
			Displayname:  &userLogin,
			ProfileImage: nil,
		}
	}
	return properties, nil
}

// ValidateUser provides a mock function with given fields: ctx, userID
func (_m *UsersClient) ValidateUser(ctx context.Context, userID string) (bool, error) {
	ret := _m.Called(ctx, userID)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string) bool); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
