package models

import (
	"time"
)

// InvitationPolicy is an enum of different invitation policies.
type InvitationPolicy string

// Enum values of invitation policies.
const (
	InvitationPolicyNone    InvitationPolicy = "NONE"
	InvitationPolicyNetwork InvitationPolicy = "NETWORK"
	InvitationPolicyAll     InvitationPolicy = "ALL"
)

// InvitePolicy represents a Twitch squad invite policy.
type InvitePolicy struct {
	ChannelID    string
	CallerID     string
	InvitePolicy InvitationPolicy

	CreatedAt time.Time
	UpdatedAt time.Time
}

// DBInvitePolicy represents an invite policy in Meepo DB.
type DBInvitePolicy struct {
	ChannelID    string
	CallerID     string
	InvitePolicy string

	CreatedAt time.Time
	UpdatedAt time.Time
}

// CreateInvitePolicyInput contains the possible input parameters that go into a CreateInvitePolicy operation.
type CreateInvitePolicyInput struct {
	ChannelID    string
	CallerID     string
	InvitePolicy InvitationPolicy
}
