package models

import (
	"time"

	"github.com/lib/pq"
)

// MemberStatus is an enum of different member statuses.
type MemberStatus string

// Enum values of member statuses.
const (
	MemberStatusActive        MemberStatus = "ACTIVE"
	MemberStatusPendingDelete MemberStatus = "PENDING_DELETE"
	MemberStatusDeleted       MemberStatus = "DELETED"
)

// Member represents a Twitch squad membership.
type Member struct {
	ID       string
	SquadID  string
	MemberID string
	Status   MemberStatus

	CreatedAt time.Time
	DeletedAt *time.Time
}

// DBMemberAndSquad represents a squad membership, and the associated squad in Meepo DB.
type DBMemberAndSquad struct {
	Member *DBMember
	Squad  *DBSquad
}

// DBMember represents a squad membership in Meepo DB.
type DBMember struct {
	ID       string
	SquadID  string
	MemberID string
	Status   string

	CreatedAt time.Time
	DeletedAt pq.NullTime
}

// CreateMemberInput contains the possible input parameters that go into a CreateMember operation.
type CreateMemberInput struct {
	SquadID  string
	MemberID string
	Status   MemberStatus
}
