package stubs

import (
	"sync"
	"time"
)

// ClockStub contains a test-defined ControlledNow time which will be returned
type ClockStub struct {
	mutex sync.Mutex

	timeNow time.Time
}

// Now as implemented by ClockStub returns the timeNow
func (c *ClockStub) Now() time.Time {
	c.mutex.Lock()
	defer c.mutex.Unlock()

	return c.timeNow
}

// Since returns the duration since timeNow
func (c *ClockStub) Since(t time.Time) time.Duration {
	c.mutex.Lock()
	defer c.mutex.Unlock()

	return c.timeNow.Sub(t)
}

// SetNow sets the stubbed time
func (c *ClockStub) SetNow(now time.Time) {
	c.mutex.Lock()
	c.timeNow = now
	c.mutex.Unlock()
}

// AddNow adds a duration to the controlled timeNow
func (c *ClockStub) AddNow(d time.Duration) {
	c.mutex.Lock()
	c.timeNow = c.timeNow.Add(d)
	c.mutex.Unlock()
}
