package util

import (
	"encoding/base64"
	"math/rand"
	"strconv"

	"github.com/gofrs/uuid"
)

// NewID produces a random base64 compressed ID for a GUID
func NewID() (string, error) {
	id, err := uuid.NewV4()
	if err != nil {
		return "", err
	}
	return base64.RawURLEncoding.EncodeToString(id.Bytes()), nil
}

// NewUserID produces a random 63-bit integer string for a User ID. It is meant to facilitate testing.
func NewUserID() string {
	id := rand.Int63()
	return strconv.FormatInt(id, 10)
}
