freeStyleJob('events-meepo-build') {
  using 'TEMPLATE-autobuild'
  concurrentBuild true

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'events-meepo-deploy-staging')
    }
    buildName('#\${BUILD_NUMBER} - \${GIT_BRANCH}')
  }

  scm {
    git {
      remote {
        github 'twitch-events/meepo', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell './scripts/build.sh'
  }
}

def environments = [
  staging: [
    credentialsId: 'events-meepo-deploy-staging'
  ],
  production: [
    credentialsId: 'events-meepo-deploy-production'
  ]
]

environments.each { environment, environmentData ->
  job {
    name "events-meepo-deploy-${environment}"
    using 'TEMPLATE-minimal-skadi-deploy'

    wrappers {
      logRotator {
        daysToKeep(14)
      }
      colorizeOutput()
      credentialsBinding {
        file('AWS_CONFIG_FILE', environmentData['credentialsId'])
      }
      buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT} ')
    }

    scm {
      git {
        remote {
          github 'twitch-events/meepo', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        branches '${GIT_COMMIT}'
        clean true
      }
    }

    steps {
      shell './scripts/deploy.sh'
    }
  }
}
