package main

import (
	"context"
	"log"
	"os"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/aws/aws-lambda-go/events"
	"github.com/aws/aws-lambda-go/lambda"
)

type handler struct {
	MeepoClient meepo.InternalMeepo
}

// Invoke calls Meepo's DeleteExpiredData endpoint
func (h *handler) Invoke(ctx context.Context, event events.CloudWatchEvent) error {
	res, err := h.MeepoClient.DeleteExpiredData(ctx, &meepo.DeleteExpiredDataRequest{})
	log.Printf("ttl_deletion: %v rows deleted", res.GetRowsDeleted())
	if err != nil {
		log.Printf("ttl_deletion: err deleting expired data = %v", err)
	}
	return err
}

func main() {
	meepoHost := os.Getenv("MEEPO_HOST")
	if meepoHost == "" {
		log.Fatalf("meepo host not found")
	}

	clientConf := twitchclient.ClientConf{
		Transport: twitchclient.TransportConf{
			MaxIdleConnsPerHost: 100,
		},
		Host: meepoHost,
	}
	meepoClient := meepo.NewInternalMeepoProtobufClient(meepoHost, twitchclient.NewHTTPClient(clientConf))

	h := &handler{
		MeepoClient: meepoClient,
	}

	lambda.Start(h.Invoke)
}
