#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

echo "AWS_CONFIG_FILE: $AWS_CONFIG_FILE"
if [ -f "$AWS_CONFIG_FILE" ];
then
   echo "AWS_CONFIG_FILE exists"
else
   echo "AWS_CONFIG_FILE does not exist"
fi

cp -R .ebextensions/ deploy/.ebextensions
cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/events/meepo:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

PROFILE='twitch-feed-dev'
if [ "$ENVIRONMENT" = 'production' ]
then
    PROFILE='twitch-feed-aws'
fi

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: events-meepo-$ENVIRONMENT
  default_region: us-west-2
EOF

echo "$ENVIRONMENT-web-$GIT_COMMIT"

eb deploy events-meepo-$ENVIRONMENT-web \
  --label $ENVIRONMENT-web-$GIT_COMMIT \
  --message "$BRANCH" \
  --timeout 20 \
  --verbose

echo "events.meepo.web.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u go-statsd-proxy-ac1754b3fa6c9917.elb.us-west-2.amazonaws.com 8125
