resource "aws_elasticache_subnet_group" "cache" {
  # Subnet group names can only use alphanumeric and hyphens
  name        = "meepo-${var.environment}"
  description = "Subnet group for memcached cluster"
  subnet_ids  = var.private_subnets
}

resource "aws_elasticache_cluster" "cache" {
  # Cluster IDs must be less than 20 characters long and only contain lowercase characters or hyphens
  cluster_id           = "meepo-${var.environment}"
  engine               = "memcached"
  port                 = 11211
  node_type            = var.elasticache_node_type
  num_cache_nodes      = var.elasticache_node_count
  apply_immediately    = true
  parameter_group_name = "default.memcached1.4"
  security_group_ids   = var.twitch_subnets_sg
  subnet_group_name    = aws_elasticache_subnet_group.cache.name
  az_mode              = "cross-az"

  tags = {
    Owner = var.owner
    Team  = var.team_display_name
  }
}

