variable "name" {
  type        = string
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "service_name" {
  type        = string
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
}

variable "project" {
  type        = string
  description = "GitHub repository name"
}

variable "team_display_name" {
  type        = string
  description = "Twitch team name, used for display purposes"
}

variable "team_name" {
  type        = string
  description = "Twitch team name.  Used for AWS resourcing."
}

variable "owner" {
  type        = string
  description = "Team email alias"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "account" {
  type        = string
  description = "AWS account to use.  E.g. twitch-feed-aws"
}

variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_key_name" {
  type        = string
  description = "Key Pair for ElasticBeanstalk Application"
}

variable "instance_type" {
  type        = string
  description = "EC2 instance type"
}

variable "sandstorm_role_arn" {
  type        = string
  description = "Sandstorm's AWS IAM Role ARN for assuming role"
}

variable "allow_assume_role_arn" {
  type        = string
  description = "AWS IAM Role ARN to allow to assume the application's role.  Used to allow jenkins to assume the development role so as to run integration tests"
  default     = ""
}

variable "vpc_id" {
  type        = string
  description = "The VPC that Twitch infrastructure should be created in.  (This VPC is usually created by systems when the account is first created.)"
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that Twitch infrastructure should be created in."
}

variable "twitch_subnets_sg" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that Twitch infrastructure should be created in."
}

variable "elasticache_node_type" {
  type        = string
  description = "Instance type for elasticache nodes."
}

variable "elasticache_node_count" {
  type        = string
  description = "Elasticache node count."
}
