variable "owner" {
  description = "Team email alias"
  default     = "events-core@justin.tv"
}

variable "name" {
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
  default     = "events-meepo"
}

variable "service_name" {
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
  default     = "meepo"
}

variable "project" {
  description = "GitHub repository name"
  default     = "twitch-events/meepo"
}

variable "team_display_name" {
  description = "Twitch team name, used for display purposes"
  default     = "Events"
}

variable "team_name" {
  description = "Twitch team name.  Used for AWS resourcing."
  default     = "events"
}

variable "description" {
  description = "Description of the key/value pair to be created"
  type        = string
}

variable "suffix" {
  description = "Suffix to be used to as part of the key to be created"
  type        = string
}

variable "development" {
  description = "Value associated with suffix for use in development"
  type        = string
}

variable "staging" {
  description = "Value associated with suffix for use in staging"
  type        = string
}

variable "production" {
  description = "Value associated with suffix for use in production"
  type        = string
}
