resource "aws_db_subnet_group" "db_subnet_group" {
  name        = "${var.service_name}-db-subnet-${var.environment}"
  description = "${var.service_name} DB subnet group"

  subnet_ids = var.private_subnets
}

resource "aws_db_parameter_group" "default" {
  name        = "pg-stat-statements-postgres-9-6"
  family      = "postgres9.6"
  description = "Enables pg_stat_statements for Postgres 9.6"

  parameter {
    name  = "pg_stat_statements.track"
    value = "ALL"
  }

  parameter {
    apply_method = "pending-reboot"
    name         = "shared_preload_libraries"
    value        = "pg_stat_statements"
  }

  parameter {
    apply_method = "pending-reboot"
    name         = "track_activity_query_size"
    value        = "2048"
  }

  tags = {
    Environment = var.environment
    Owner       = var.owner
    Project     = var.project
    Team        = var.team_display_name
  }
}

resource "aws_db_instance" "master" {
  lifecycle {
    ignore_changes = ["engine_version"]
  }

  engine            = "postgres"
  engine_version    = "9.6.6"
  instance_class    = var.rds_instance_type
  storage_type      = "gp2"
  allocated_storage = var.rds_storage
  multi_az          = true

  identifier = "${var.name}-${var.environment}"
  name       = var.service_name
  username   = "master"
  password   = "temporary"

  publicly_accessible = false

  vpc_security_group_ids = var.twitch_subnets_sg

  port                 = 5432
  db_subnet_group_name = aws_db_subnet_group.db_subnet_group.name
  parameter_group_name = aws_db_parameter_group.default.name

  backup_retention_period = 5
  backup_window           = "02:00-04:00"

  deletion_protection = true

  tags = {
    Environment = var.environment
    Name        = var.name
    Owner       = var.owner
    Project     = var.project
    Team        = var.team_display_name
  }
}
