resource "aws_route53_zone" "a2z" {
  name    = "${var.environment}.${var.service_name}.twitch.a2z.com"
  comment = "Public service resolution for a2z"
  tags = {
    Owner   = var.owner
    Project = var.project
    Team    = var.team_display_name
  }
}

resource "aws_route53_record" "test_record" {
  zone_id = aws_route53_zone.a2z.zone_id
  name    = "_test.${aws_route53_zone.a2z.name}"
  type    = "TXT"
  ttl     = 300
  records = ["If you're reading this it works"]
}

resource "aws_route53_record" "meepo" {
  zone_id = aws_route53_zone.a2z.zone_id
  name    = aws_route53_zone.a2z.name
  type    = "A"

  alias {
    name                   = var.elb_dns_name
    zone_id                = var.elb_zone_id
    evaluate_target_health = true
  }
}
