variable "account_id" {
  type        = string
  description = "AWS account the VPC endpoint service should be setup."
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS region the VPC endpoint service should be setup."
}

variable "name" {
  type        = string
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "service_name" {
  type        = string
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
}

variable "project" {
  type        = string
  description = "GitHub repository name"
}

variable "team_display_name" {
  type        = string
  description = "Twitch team name, used for display purposes"
}

variable "owner" {
  type        = string
  description = "Team email alias"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "elb_dns_name" {
  type        = string
  description = "DNS name for the load balancer"
}

variable "vpc_id" {
  type        = string
  description = "The VPC that Twitch infrastructure should be created in.  (This VPC is usually created by systems when the account is first created.)"
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that Twitch infrastructure should be created in."
}

variable "allowed_principals" {
  type        = list(string)
  description = "the arns that are whitelisted to access the VPC endpoint service."
}
