resource "aws_vpc_endpoint" "hallpass" {
  vpc_id             = var.vpc_id
  vpc_endpoint_type  = "Interface"
  service_name       = var.hallpass_service_name
  subnet_ids         = var.private_subnets
  security_group_ids = var.security_groups

  tags = {
    Environment = var.environment
    Name        = "hallpass-${var.environment}"
    Owner       = var.owner
    Project     = var.project
    Team        = var.team_display_name
  }
}

resource "aws_route53_zone" "hallpass" {
  name = var.hallpass_dns_name
  vpc {
    vpc_id = var.vpc_id
  }
}

resource "aws_route53_record" "hallpass" {
  zone_id = aws_route53_zone.hallpass.zone_id
  name    = aws_route53_zone.hallpass.name
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.hallpass.dns_entry.0.dns_name
    zone_id                = aws_vpc_endpoint.hallpass.dns_entry.0.hosted_zone_id
    evaluate_target_health = false
  }
}
