variable "project" {
  type        = string
  description = "GitHub repository name"
}

variable "team_display_name" {
  type        = string
  description = "Twitch team name, used for display purposes"
}

variable "owner" {
  type        = string
  description = "Team email alias"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "vpc_id" {
  type        = string
  description = "The VPC in which VPC endpoints should be created in"
}

variable "private_subnets" {
  type        = list(string)
  description = "The subnets in the VPC that VPC endpoints should be created in"
}

variable "security_groups" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that VPC endpoints should be created in"
}

variable "artifactory_dns_name" {
  type        = string
  description = "Artifactory VPC Endpoint DNS name"
}

variable "artifactory_service_name" {
  type        = string
  description = "Artifactory VPC Endpoint Service name"
}

variable "follows_dns_name" {
  type        = string
  description = "Follows VPC Endpoint DNS name"
}

variable "follows_service_name" {
  type        = string
  description = "Follows VPC Endpoint Service name"
}

variable "friendship_dns_name" {
  type        = string
  description = "Friendship VPC Endpoint DNS name"
}

variable "friendship_service_name" {
  type        = string
  description = "Friendship VPC Endpoint Service name"
}

variable "hallpass_dns_name" {
  type        = string
  description = "Hallpass VPC Endpoint DNS name"
}

variable "hallpass_service_name" {
  type        = string
  description = "Hallpass VPC Endpoint Service name"
}

variable "liveline_dns_name" {
  type        = string
  description = "Liveline VPC Endpoint DNS name"
}

variable "liveline_service_name" {
  type        = string
  description = "Liveline VPC Endpoint Service name"
}

variable "receiver_dns_name" {
  type        = string
  description = "Receiver VPC Endpoint DNS name"
}

variable "receiver_service_name" {
  type        = string
  description = "Receiver VPC Endpoint Service name"
}

variable "ripley_dns_name" {
  type        = string
  description = "Ripley VPC Endpoint DNS name"
}

variable "ripley_service_name" {
  type        = string
  description = "Ripley VPC Endpoint Service name"
}

variable "roster_dns_name" {
  type        = string
  description = "Roster VPC Endpoint DNS name"
}

variable "roster_service_name" {
  type        = string
  description = "Roster VPC Endpoint Service name"
}

variable "users_dns_name" {
  type        = string
  description = "Users Service VPC Endpoint DNS name"
}

variable "users_service_name" {
  type        = string
  description = "Users Service VPC Endpoint Service name"
}
