variable "region" {
  description = "AWS region the service is in"
  default     = "us-west-2"
}

variable "account_staging" {
  description = "AWS account to use.  E.g. twitch-feed-aws"
  default     = "twitch-feed-dev"
}

variable "account_production" {
  description = "AWS account to use.  E.g. twitch-feed-aws"
  default     = "twitch-feed-aws"
}

variable "service_name" {
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
  default     = "meepo"
}

provider "aws" {
  alias   = "development"
  profile = var.account_staging
  region  = var.region
}

provider "aws" {
  alias   = "staging"
  profile = var.account_staging
  region  = var.region
}

provider "aws" {
  alias   = "production"
  profile = var.account_production
  region  = var.region
}
