# Values and providers that are common to all Production root mdoules.
# Each root module has a symlink to this file.

variable "region" {
  description = "AWS region the service is in"
  default     = "us-west-2"
}

variable "account" {
  description = "AWS account to use.  E.g. twitch-feed-aws"
  default     = "twitch-feed-aws"
}

variable "account_id" {
  description = "AWS account ID to use."
  default     = "914569885343"
}

variable "owner" {
  description = "Team email alias"
  default     = "events-core@justin.tv"
}

variable "environment" {
  description = "Service environment"
  default     = "production"
}

variable "name" {
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
  default     = "events-meepo"
}

variable "service_name" {
  description = "Service name used for alphanumeric only AWS resourcing (RDS)"
  default     = "meepo"
}

variable "project" {
  description = "GitHub repository name"
  default     = "twitch-events/meepo"
}

variable "team_display_name" {
  description = "Twitch team name, used for display purposes"
  default     = "Events"
}

variable "team_name" {
  description = "Twitch team name.  Used for AWS resourcing."
  default     = "events"
}

provider "aws" {
  profile = var.account
  region  = var.region
}

