terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/meepo/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

# Create a data source to retrieve information on the VPC that Systems set up in the
# AWS account.
data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = var.account
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = var.region
    profile = var.account
  }
}

module "meepo" {
  name              = var.name
  service_name      = var.service_name
  project           = var.project
  team_name         = var.team_name
  team_display_name = var.team_display_name
  owner             = var.owner

  source                       = "../../modules/meepo"
  instance_type                = "t2.small"
  asg_max_size                 = 3
  asg_min_size                 = 2
  environment                  = var.environment
  account                      = var.account
  aws_key_name                 = "events-meepo-staging"
  sandstorm_role_arn           = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/events-staging"
  allow_assume_role_arn        = "arn:aws:iam::989470033077:user/devtools-jenkins"

  vpc_id            = data.terraform_remote_state.account.outputs.vpc_id
  private_subnets   = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  twitch_subnets_sg = split(",", data.terraform_remote_state.account.outputs.twitch_subnets_sg)

  elasticache_node_type  = "cache.m3.medium"
  elasticache_node_count = "2"
}

module "route53" {
  source = "../../modules/route53"

  service_name      = var.service_name
  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner
  environment       = var.environment

  elb_dns_name = module.meepo.elb_dns_name
  elb_zone_id  = module.meepo.elb_zone_id
}

module "vpc_endpoint_service" {
  source = "../../modules/vpc_endpoint_service"

  account_id        = var.account_id
  name              = var.name
  service_name      = var.service_name
  project           = var.project
  team_display_name = var.team_display_name
  owner             = var.owner
  environment       = var.environment

  elb_dns_name    = module.meepo.elb_dns_name
  vpc_id          = data.terraform_remote_state.account.outputs.vpc_id
  private_subnets = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  allowed_principals = [
    "arn:aws:iam::022085415566:root", // GrandDAds
  ]
}

output "elb_dns_name" {
  value = module.meepo.elb_dns_name
}

output "elb_zone_id" {
  value = module.meepo.elb_zone_id
}
