// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchFriendshipTwirp/twirp.proto

/*
Package TwitchFriendshipTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchFriendshipTwirp/twirp.proto
*/
package TwitchFriendshipTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =================
// Friends Interface
// =================

// Friends manages friend relationships between users.
type Friends interface {
	// GetFriendships returns the IDs of the given user's friends.
	GetFriendships(context.Context, *GetFriendshipsReq) (*GetFriendshipsResp, error)

	// GetIncomingFriendRequests returns the IDs of users who have open friend requests with the given user.
	GetIncomingFriendRequests(context.Context, *GetIncomingFriendRequestsReq) (*GetIncomingFriendRequestsResp, error)

	// GetOutgoingFriendRequests returns the IDs of users with whom the given user has open friend requests.
	GetOutgoingFriendRequests(context.Context, *GetOutgoingFriendRequestsReq) (*GetOutgoingFriendRequestsResp, error)

	// GetRelationships returns the friend relationships active between a pair of users, for any given number of pairs.
	GetRelationships(context.Context, *GetRelationshipsReq) (*GetRelationshipsResp, error)

	// GetUnreadCount returns the number of unread incoming friend requests.
	GetUnreadCount(context.Context, *GetUnreadCountReq) (*GetUnreadCountResp, error)

	// ClearUnreadCount sets the number of unread incoming friend requests to 0.
	ClearUnreadCount(context.Context, *ClearUnreadCountReq) (*ClearUnreadCountResp, error)

	// RejectFriendRequest rejects an incoming friend request from the target user, or rejects an outgoing request to the target user.
	RejectFriendRequest(context.Context, *RejectFriendRequestReq) (*RejectFriendRequestResp, error)

	// GetRecommendedFriends lists recommended friends for a user. Deprecated.
	GetRecommendedFriends(context.Context, *GetRecommendedFriendsReq) (*GetRecommendedFriendsResp, error)

	// DismissRecommendedFriend dismisses a friend recommendation. Deprecated.
	DismissRecommendedFriend(context.Context, *DismissRecommendedFriendReq) (*DismissRecommendedFriendResp, error)

	// IsFriend returns whether two users are friends.
	IsFriend(context.Context, *IsFriendReq) (*IsFriendResp, error)

	// AddFriend sends a friend request to the target user.
	AddFriend(context.Context, *AddFriendReq) (*AddFriendResp, error)

	// AcceptFriendRequest accepts an incoming friend request.
	AcceptFriendRequest(context.Context, *AcceptFriendRequestReq) (*AcceptFriendRequestResp, error)

	// RemoveFriend unfriends the target user.
	RemoveFriend(context.Context, *RemoveFriendReq) (*RemoveFriendResp, error)

	// IsFamiliar returns whether the target user is familiar to the source user.
	IsFamiliar(context.Context, *IsFamiliarReq) (*IsFamiliarResp, error)

	// Permanently hard deletes all data belonging to the provided user.
	// Should ONLY be used for GDPR purposes.
	HardDeleteUserData(context.Context, *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error)
}

// =======================
// Friends Protobuf Client
// =======================

type friendsProtobufClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewFriendsProtobufClient creates a Protobuf client that implements the Friends interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewFriendsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Friends {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FriendsPathPrefix
	urls := [15]string{
		prefix + "GetFriendships",
		prefix + "GetIncomingFriendRequests",
		prefix + "GetOutgoingFriendRequests",
		prefix + "GetRelationships",
		prefix + "GetUnreadCount",
		prefix + "ClearUnreadCount",
		prefix + "RejectFriendRequest",
		prefix + "GetRecommendedFriends",
		prefix + "DismissRecommendedFriend",
		prefix + "IsFriend",
		prefix + "AddFriend",
		prefix + "AcceptFriendRequest",
		prefix + "RemoveFriend",
		prefix + "IsFamiliar",
		prefix + "HardDeleteUserData",
	}

	return &friendsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *friendsProtobufClient) GetFriendships(ctx context.Context, in *GetFriendshipsReq) (*GetFriendshipsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendships")
	out := new(GetFriendshipsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) GetIncomingFriendRequests(ctx context.Context, in *GetIncomingFriendRequestsReq) (*GetIncomingFriendRequestsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingFriendRequests")
	out := new(GetIncomingFriendRequestsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) GetOutgoingFriendRequests(ctx context.Context, in *GetOutgoingFriendRequestsReq) (*GetOutgoingFriendRequestsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetOutgoingFriendRequests")
	out := new(GetOutgoingFriendRequestsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) GetRelationships(ctx context.Context, in *GetRelationshipsReq) (*GetRelationshipsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetRelationships")
	out := new(GetRelationshipsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) GetUnreadCount(ctx context.Context, in *GetUnreadCountReq) (*GetUnreadCountResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetUnreadCount")
	out := new(GetUnreadCountResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) ClearUnreadCount(ctx context.Context, in *ClearUnreadCountReq) (*ClearUnreadCountResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "ClearUnreadCount")
	out := new(ClearUnreadCountResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) RejectFriendRequest(ctx context.Context, in *RejectFriendRequestReq) (*RejectFriendRequestResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "RejectFriendRequest")
	out := new(RejectFriendRequestResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) GetRecommendedFriends(ctx context.Context, in *GetRecommendedFriendsReq) (*GetRecommendedFriendsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedFriends")
	out := new(GetRecommendedFriendsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) DismissRecommendedFriend(ctx context.Context, in *DismissRecommendedFriendReq) (*DismissRecommendedFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "DismissRecommendedFriend")
	out := new(DismissRecommendedFriendResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) IsFriend(ctx context.Context, in *IsFriendReq) (*IsFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "IsFriend")
	out := new(IsFriendResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) AddFriend(ctx context.Context, in *AddFriendReq) (*AddFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "AddFriend")
	out := new(AddFriendResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) AcceptFriendRequest(ctx context.Context, in *AcceptFriendRequestReq) (*AcceptFriendRequestResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptFriendRequest")
	out := new(AcceptFriendRequestResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) RemoveFriend(ctx context.Context, in *RemoveFriendReq) (*RemoveFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFriend")
	out := new(RemoveFriendResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) IsFamiliar(ctx context.Context, in *IsFamiliarReq) (*IsFamiliarResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "IsFamiliar")
	out := new(IsFamiliarResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsProtobufClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	out := new(HardDeleteUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================
// Friends JSON Client
// ===================

type friendsJSONClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewFriendsJSONClient creates a JSON client that implements the Friends interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewFriendsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Friends {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FriendsPathPrefix
	urls := [15]string{
		prefix + "GetFriendships",
		prefix + "GetIncomingFriendRequests",
		prefix + "GetOutgoingFriendRequests",
		prefix + "GetRelationships",
		prefix + "GetUnreadCount",
		prefix + "ClearUnreadCount",
		prefix + "RejectFriendRequest",
		prefix + "GetRecommendedFriends",
		prefix + "DismissRecommendedFriend",
		prefix + "IsFriend",
		prefix + "AddFriend",
		prefix + "AcceptFriendRequest",
		prefix + "RemoveFriend",
		prefix + "IsFamiliar",
		prefix + "HardDeleteUserData",
	}

	return &friendsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *friendsJSONClient) GetFriendships(ctx context.Context, in *GetFriendshipsReq) (*GetFriendshipsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendships")
	out := new(GetFriendshipsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) GetIncomingFriendRequests(ctx context.Context, in *GetIncomingFriendRequestsReq) (*GetIncomingFriendRequestsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingFriendRequests")
	out := new(GetIncomingFriendRequestsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) GetOutgoingFriendRequests(ctx context.Context, in *GetOutgoingFriendRequestsReq) (*GetOutgoingFriendRequestsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetOutgoingFriendRequests")
	out := new(GetOutgoingFriendRequestsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) GetRelationships(ctx context.Context, in *GetRelationshipsReq) (*GetRelationshipsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetRelationships")
	out := new(GetRelationshipsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) GetUnreadCount(ctx context.Context, in *GetUnreadCountReq) (*GetUnreadCountResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetUnreadCount")
	out := new(GetUnreadCountResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) ClearUnreadCount(ctx context.Context, in *ClearUnreadCountReq) (*ClearUnreadCountResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "ClearUnreadCount")
	out := new(ClearUnreadCountResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) RejectFriendRequest(ctx context.Context, in *RejectFriendRequestReq) (*RejectFriendRequestResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "RejectFriendRequest")
	out := new(RejectFriendRequestResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) GetRecommendedFriends(ctx context.Context, in *GetRecommendedFriendsReq) (*GetRecommendedFriendsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedFriends")
	out := new(GetRecommendedFriendsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) DismissRecommendedFriend(ctx context.Context, in *DismissRecommendedFriendReq) (*DismissRecommendedFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "DismissRecommendedFriend")
	out := new(DismissRecommendedFriendResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) IsFriend(ctx context.Context, in *IsFriendReq) (*IsFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "IsFriend")
	out := new(IsFriendResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) AddFriend(ctx context.Context, in *AddFriendReq) (*AddFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "AddFriend")
	out := new(AddFriendResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) AcceptFriendRequest(ctx context.Context, in *AcceptFriendRequestReq) (*AcceptFriendRequestResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptFriendRequest")
	out := new(AcceptFriendRequestResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) RemoveFriend(ctx context.Context, in *RemoveFriendReq) (*RemoveFriendResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFriend")
	out := new(RemoveFriendResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) IsFamiliar(ctx context.Context, in *IsFamiliarReq) (*IsFamiliarResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "IsFamiliar")
	out := new(IsFamiliarResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *friendsJSONClient) HardDeleteUserData(ctx context.Context, in *HardDeleteUserDataRequest) (*HardDeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	out := new(HardDeleteUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// Friends Server Handler
// ======================

type friendsServer struct {
	Friends
	hooks *twirp.ServerHooks
}

func NewFriendsServer(svc Friends, hooks *twirp.ServerHooks) TwirpServer {
	return &friendsServer{
		Friends: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *friendsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// FriendsPathPrefix is used for all URL paths on a twirp Friends server.
// Requests are always: POST FriendsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const FriendsPathPrefix = "/twirp/code.justin.tv.chat.friendship.Friends/"

func (s *friendsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.friendship")
	ctx = ctxsetters.WithServiceName(ctx, "Friends")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetFriendships":
		s.serveGetFriendships(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetIncomingFriendRequests":
		s.serveGetIncomingFriendRequests(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetOutgoingFriendRequests":
		s.serveGetOutgoingFriendRequests(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetRelationships":
		s.serveGetRelationships(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetUnreadCount":
		s.serveGetUnreadCount(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/ClearUnreadCount":
		s.serveClearUnreadCount(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/RejectFriendRequest":
		s.serveRejectFriendRequest(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/GetRecommendedFriends":
		s.serveGetRecommendedFriends(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/DismissRecommendedFriend":
		s.serveDismissRecommendedFriend(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/IsFriend":
		s.serveIsFriend(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/AddFriend":
		s.serveAddFriend(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/AcceptFriendRequest":
		s.serveAcceptFriendRequest(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/RemoveFriend":
		s.serveRemoveFriend(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/IsFamiliar":
		s.serveIsFamiliar(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.friendship.Friends/HardDeleteUserData":
		s.serveHardDeleteUserData(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *friendsServer) serveGetFriendships(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFriendshipsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFriendshipsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetFriendshipsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFriendshipsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetFriendshipsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetFriendships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFriendshipsResp and nil error while calling GetFriendships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetFriendshipsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFriendships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetFriendshipsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetFriendshipsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetFriendships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFriendshipsResp and nil error while calling GetFriendships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetIncomingFriendRequests(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIncomingFriendRequestsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIncomingFriendRequestsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetIncomingFriendRequestsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingFriendRequests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetIncomingFriendRequestsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIncomingFriendRequestsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetIncomingFriendRequests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingFriendRequestsResp and nil error while calling GetIncomingFriendRequests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetIncomingFriendRequestsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingFriendRequests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetIncomingFriendRequestsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIncomingFriendRequestsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetIncomingFriendRequests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingFriendRequestsResp and nil error while calling GetIncomingFriendRequests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetOutgoingFriendRequests(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOutgoingFriendRequestsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOutgoingFriendRequestsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetOutgoingFriendRequestsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOutgoingFriendRequests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOutgoingFriendRequestsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOutgoingFriendRequestsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetOutgoingFriendRequests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOutgoingFriendRequestsResp and nil error while calling GetOutgoingFriendRequests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetOutgoingFriendRequestsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOutgoingFriendRequests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOutgoingFriendRequestsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOutgoingFriendRequestsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetOutgoingFriendRequests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOutgoingFriendRequestsResp and nil error while calling GetOutgoingFriendRequests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetRelationships(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRelationshipsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRelationshipsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetRelationshipsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRelationships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRelationshipsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRelationshipsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetRelationships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelationshipsResp and nil error while calling GetRelationships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetRelationshipsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRelationships")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRelationshipsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRelationshipsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetRelationships(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelationshipsResp and nil error while calling GetRelationships. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetUnreadCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUnreadCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUnreadCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetUnreadCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUnreadCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUnreadCountReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUnreadCountResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetUnreadCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUnreadCountResp and nil error while calling GetUnreadCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetUnreadCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUnreadCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUnreadCountReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUnreadCountResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetUnreadCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUnreadCountResp and nil error while calling GetUnreadCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveClearUnreadCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClearUnreadCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClearUnreadCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveClearUnreadCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClearUnreadCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClearUnreadCountReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClearUnreadCountResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.ClearUnreadCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClearUnreadCountResp and nil error while calling ClearUnreadCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveClearUnreadCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClearUnreadCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ClearUnreadCountReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClearUnreadCountResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.ClearUnreadCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClearUnreadCountResp and nil error while calling ClearUnreadCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveRejectFriendRequest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRejectFriendRequestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRejectFriendRequestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveRejectFriendRequestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectFriendRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RejectFriendRequestReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RejectFriendRequestResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.RejectFriendRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectFriendRequestResp and nil error while calling RejectFriendRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveRejectFriendRequestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectFriendRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RejectFriendRequestReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RejectFriendRequestResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.RejectFriendRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectFriendRequestResp and nil error while calling RejectFriendRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetRecommendedFriends(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecommendedFriendsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecommendedFriendsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveGetRecommendedFriendsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedFriends")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecommendedFriendsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecommendedFriendsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetRecommendedFriends(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecommendedFriendsResp and nil error while calling GetRecommendedFriends. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveGetRecommendedFriendsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecommendedFriends")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecommendedFriendsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecommendedFriendsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.GetRecommendedFriends(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecommendedFriendsResp and nil error while calling GetRecommendedFriends. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveDismissRecommendedFriend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDismissRecommendedFriendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDismissRecommendedFriendProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveDismissRecommendedFriendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DismissRecommendedFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DismissRecommendedFriendReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DismissRecommendedFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.DismissRecommendedFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DismissRecommendedFriendResp and nil error while calling DismissRecommendedFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveDismissRecommendedFriendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DismissRecommendedFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DismissRecommendedFriendReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DismissRecommendedFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.DismissRecommendedFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DismissRecommendedFriendResp and nil error while calling DismissRecommendedFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveIsFriend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsFriendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsFriendProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveIsFriendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsFriendReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.IsFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsFriendResp and nil error while calling IsFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveIsFriendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IsFriendReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.IsFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsFriendResp and nil error while calling IsFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveAddFriend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddFriendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddFriendProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveAddFriendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddFriendReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.AddFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFriendResp and nil error while calling AddFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveAddFriendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddFriendReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.AddFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddFriendResp and nil error while calling AddFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveAcceptFriendRequest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAcceptFriendRequestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAcceptFriendRequestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveAcceptFriendRequestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptFriendRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AcceptFriendRequestReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AcceptFriendRequestResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.AcceptFriendRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptFriendRequestResp and nil error while calling AcceptFriendRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveAcceptFriendRequestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptFriendRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AcceptFriendRequestReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AcceptFriendRequestResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.AcceptFriendRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptFriendRequestResp and nil error while calling AcceptFriendRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveRemoveFriend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveFriendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveFriendProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveRemoveFriendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveFriendReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.RemoveFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFriendResp and nil error while calling RemoveFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveRemoveFriendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFriend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveFriendReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFriendResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.RemoveFriend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFriendResp and nil error while calling RemoveFriend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveIsFamiliar(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsFamiliarJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsFamiliarProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveIsFamiliarJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFamiliar")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsFamiliarReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsFamiliarResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.IsFamiliar(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsFamiliarResp and nil error while calling IsFamiliar. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveIsFamiliarProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsFamiliar")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IsFamiliarReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsFamiliarResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.IsFamiliar(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsFamiliarResp and nil error while calling IsFamiliar. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveHardDeleteUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHardDeleteUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHardDeleteUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *friendsServer) serveHardDeleteUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HardDeleteUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.HardDeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) serveHardDeleteUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HardDeleteUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HardDeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Friends.HardDeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteUserDataResponse and nil error while calling HardDeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *friendsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *friendsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *friendsServer) PathPrefix() string {
	return FriendsPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1637 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x4b, 0x53, 0xdc, 0xc6,
	0x16, 0x46, 0x0c, 0x8f, 0xe1, 0x0c, 0x33, 0x8c, 0x9b, 0xf7, 0xf8, 0xc5, 0x55, 0x5d, 0xd7, 0xc5,
	0x18, 0x66, 0xee, 0xc5, 0xd7, 0x49, 0x9c, 0x38, 0x0b, 0xcc, 0xbb, 0xca, 0x76, 0x28, 0x01, 0x79,
	0x56, 0x4a, 0x25, 0xa4, 0x66, 0x68, 0x7b, 0xa4, 0x6e, 0xba, 0x7b, 0x00, 0xa7, 0xca, 0x8b, 0x54,
	0xaa, 0xb2, 0x49, 0x16, 0xd9, 0x38, 0x95, 0x75, 0x36, 0xd9, 0x66, 0x9f, 0x45, 0xfe, 0x4c, 0x76,
	0xf9, 0x13, 0x29, 0xbd, 0x46, 0x9a, 0x41, 0x42, 0x03, 0x86, 0x3c, 0x36, 0xd4, 0xe8, 0xf4, 0x77,
	0xbe, 0x3e, 0xa7, 0xfb, 0x74, 0xeb, 0x3b, 0x02, 0x1e, 0x98, 0xd4, 0xc2, 0xd5, 0xe7, 0x4d, 0x21,
	0x89, 0x53, 0x95, 0x47, 0x35, 0xc3, 0xfe, 0xc2, 0xa9, 0xed, 0x1c, 0x13, 0x69, 0x1e, 0xac, 0x71,
	0x82, 0x1d, 0x4b, 0x1c, 0x10, 0xb6, 0x73, 0x4c, 0x38, 0xab, 0x49, 0xf7, 0x6f, 0x95, 0x71, 0x2a,
	0x29, 0xba, 0xd5, 0xee, 0x56, 0x35, 0x0f, 0x0c, 0x59, 0xdd, 0x6f, 0x39, 0x54, 0x6e, 0xd7, 0x29,
	0xad, 0x37, 0x70, 0xcd, 0x43, 0xef, 0x35, 0xf7, 0x6b, 0x92, 0xd8, 0x58, 0x48, 0xc3, 0x0e, 0x08,
	0x54, 0x0d, 0xf2, 0x5b, 0x46, 0x1d, 0x6f, 0x3a, 0xfb, 0x14, 0xa9, 0x50, 0x3c, 0x30, 0x84, 0xce,
	0x38, 0x3e, 0xd2, 0x99, 0x51, 0xc7, 0x53, 0xca, 0x8c, 0x32, 0x9b, 0xd7, 0x0a, 0x07, 0x86, 0xd8,
	0xe2, 0xf8, 0xc8, 0xc5, 0x85, 0x18, 0x07, 0x9f, 0x48, 0x1f, 0xd3, 0xdb, 0xc2, 0x3c, 0xc3, 0x27,
	0xd2, 0xc5, 0xa8, 0x3f, 0x2b, 0x70, 0x6d, 0x1d, 0xcb, 0x28, 0x6e, 0xa1, 0xe1, 0x43, 0x34, 0x09,
	0x83, 0x4d, 0x81, 0xb9, 0x4e, 0x2c, 0x8f, 0x77, 0x48, 0x1b, 0x70, 0x1f, 0x37, 0x2d, 0x34, 0x06,
	0xfd, 0x0d, 0x62, 0x13, 0xe9, 0x51, 0xe5, 0x34, 0xff, 0x01, 0xed, 0x40, 0x49, 0x50, 0x2e, 0x75,
	0x8b, 0x70, 0x6c, 0x4a, 0x42, 0x9d, 0xa9, 0xdc, 0x8c, 0x32, 0x5b, 0x5a, 0x5c, 0xa8, 0x9e, 0x9d,
	0x72, 0x75, 0x9b, 0x72, 0xb9, 0x12, 0x3a, 0x69, 0x45, 0x11, 0x7f, 0x44, 0x13, 0x30, 0x60, 0x36,
	0xb9, 0xa0, 0x7c, 0xaa, 0xcf, 0x8f, 0xc1, 0x7f, 0x52, 0x7f, 0x55, 0x00, 0x75, 0x86, 0x2c, 0x18,
	0x7a, 0x02, 0x85, 0x88, 0x59, 0x4c, 0x29, 0x33, 0xb9, 0xd9, 0xc2, 0xe2, 0x5c, 0x56, 0x04, 0x11,
	0x8b, 0x16, 0x77, 0x77, 0x13, 0x95, 0x54, 0x1a, 0x8d, 0x30, 0x51, 0xef, 0x01, 0xad, 0xc2, 0x90,
	0xbb, 0x90, 0x3a, 0x71, 0xf6, 0xa9, 0x97, 0x63, 0x61, 0x71, 0x36, 0x6b, 0x86, 0x70, 0xcb, 0xb4,
	0x3c, 0x0b, 0x7e, 0xa9, 0x27, 0x00, 0xd1, 0xbc, 0xe9, 0x8b, 0xfd, 0x10, 0xc0, 0xe4, 0xd8, 0x90,
	0xd8, 0xd2, 0x0d, 0x7f, 0xc5, 0x0b, 0x8b, 0x95, 0xaa, 0x5f, 0x25, 0xd5, 0xb0, 0x4a, 0xaa, 0x3b,
	0x61, 0x95, 0x68, 0x43, 0x01, 0x7a, 0x49, 0xc6, 0xd6, 0x2e, 0xd7, 0xb6, 0x76, 0xbf, 0x28, 0x70,
	0x63, 0x1d, 0xcb, 0x4d, 0xc7, 0xa4, 0x36, 0x71, 0xea, 0x7e, 0x14, 0x1a, 0x3e, 0x6c, 0x62, 0x21,
	0xff, 0xfe, 0x3b, 0xff, 0x5b, 0x2f, 0xdc, 0x3c, 0x23, 0x7a, 0xc1, 0x90, 0x0d, 0x13, 0x24, 0x71,
	0x34, 0xa8, 0x87, 0x07, 0x59, 0x71, 0x25, 0x72, 0x6b, 0x29, 0xa4, 0x29, 0x55, 0x32, 0x03, 0x05,
	0xef, 0xc7, 0xae, 0xc3, 0xb1, 0x61, 0x79, 0x2b, 0x92, 0xd3, 0xe2, 0x26, 0xb4, 0x0b, 0x60, 0x53,
	0x21, 0x35, 0x6c, 0x62, 0x47, 0x7a, 0x49, 0x5e, 0x38, 0xb4, 0x18, 0x51, 0x7b, 0x79, 0xf6, 0x5f,
	0xb8, 0x3c, 0xbf, 0x52, 0x60, 0x3c, 0x71, 0xb2, 0xbf, 0xa2, 0x54, 0x3f, 0x68, 0xca, 0x3a, 0xfd,
	0xe7, 0x95, 0xea, 0xef, 0x8a, 0x57, 0xaa, 0x69, 0xd1, 0xfb, 0xa5, 0x4a, 0x13, 0x47, 0xbb, 0x2d,
	0xd5, 0x44, 0x6e, 0x2d, 0x85, 0xb4, 0x9b, 0x0b, 0xed, 0xcd, 0x2a, 0x26, 0x31, 0x9c, 0x3f, 0xb5,
	0x62, 0x30, 0x8c, 0xae, 0x63, 0xa9, 0xe1, 0x86, 0xe1, 0x6e, 0x4d, 0xeb, 0x65, 0xf6, 0x0c, 0x8a,
	0x41, 0x08, 0x3a, 0x33, 0x08, 0xef, 0xfa, 0xd5, 0xb0, 0xeb, 0x05, 0xba, 0x65, 0x10, 0xae, 0x15,
	0x9a, 0xad, 0xdf, 0x42, 0xfd, 0x18, 0x20, 0x1a, 0x42, 0xff, 0x76, 0xcb, 0xaa, 0xc9, 0x4d, 0xac,
	0xb7, 0xe7, 0x39, 0xec, 0x5b, 0x7d, 0xa4, 0x8b, 0x92, 0x06, 0xaf, 0x63, 0xd9, 0x42, 0xf5, 0xfa,
	0x28, 0xdf, 0xea, 0xa3, 0xd4, 0xe7, 0x30, 0x76, 0x3a, 0x01, 0xc1, 0x90, 0x06, 0x45, 0x1e, 0x37,
	0x06, 0x19, 0xcc, 0x67, 0x65, 0x10, 0x67, 0xd2, 0xda, 0x29, 0xd4, 0xef, 0x73, 0x30, 0x1c, 0x1f,
	0xbf, 0xcc, 0x44, 0xd0, 0x13, 0x80, 0x28, 0x8c, 0xe0, 0x45, 0x79, 0x8e, 0x57, 0xf1, 0x46, 0x8f,
	0x16, 0xf3, 0x47, 0x36, 0x8c, 0x27, 0xde, 0xbf, 0x6f, 0x74, 0x71, 0x6e, 0xf4, 0x68, 0xc9, 0xac,
	0xee, 0x74, 0x89, 0x67, 0x28, 0x38, 0x1f, 0x17, 0x3b, 0x97, 0xee, 0x74, 0x89, 0xac, 0x8f, 0x4b,
	0xed, 0xfb, 0xa0, 0x56, 0x61, 0x74, 0xb9, 0x81, 0x0d, 0xee, 0xbf, 0x2a, 0x96, 0x69, 0xd3, 0x91,
	0x67, 0xdd, 0x76, 0xea, 0x04, 0x8c, 0x9d, 0xc6, 0x0b, 0xa6, 0xce, 0x7b, 0xc2, 0xae, 0x5b, 0x96,
	0x39, 0x4f, 0x53, 0x75, 0x70, 0xb8, 0x97, 0x86, 0xe9, 0x3e, 0x78, 0xe0, 0x9c, 0xe6, 0x3f, 0xa8,
	0x16, 0x4c, 0x68, 0xf8, 0x39, 0x36, 0x65, 0xfb, 0xcd, 0x83, 0x0f, 0x2f, 0xf5, 0x30, 0x4c, 0xc3,
	0x64, 0xe2, 0x2c, 0x82, 0xa9, 0xf7, 0x61, 0xca, 0x3b, 0x27, 0x26, 0xb5, 0x6d, 0xec, 0x58, 0xd8,
	0x0a, 0x4a, 0xe7, 0xcc, 0x0c, 0x4f, 0x60, 0x3a, 0xc5, 0x49, 0x30, 0xf4, 0x19, 0x8c, 0xf0, 0x70,
	0xc4, 0xdf, 0x8a, 0xe0, 0x8c, 0xfd, 0x2f, 0xfb, 0x8c, 0x75, 0x10, 0x6a, 0x9d, 0x4c, 0xea, 0x0a,
	0x5c, 0x3b, 0x85, 0x4a, 0xbf, 0x18, 0x27, 0x60, 0x80, 0x63, 0x43, 0x50, 0x27, 0x58, 0x95, 0xe0,
	0x49, 0x25, 0x70, 0x7d, 0x85, 0x08, 0x9b, 0x08, 0x71, 0x7a, 0xca, 0x4b, 0x5e, 0xfa, 0x5b, 0x70,
	0x23, 0x7d, 0x2a, 0xc1, 0xd4, 0x4f, 0xa0, 0xb0, 0x29, 0xae, 0x66, 0xea, 0x7b, 0x30, 0x1c, 0x51,
	0x0b, 0x86, 0xae, 0xc3, 0x10, 0x11, 0xba, 0xbf, 0xde, 0x41, 0x8f, 0x93, 0x27, 0x01, 0x40, 0xfd,
	0x52, 0x81, 0xe1, 0x25, 0xeb, 0x6a, 0x16, 0x01, 0xdd, 0x81, 0x12, 0x11, 0x3a, 0x8f, 0x16, 0xc0,
	0xbb, 0xc7, 0xf2, 0x5a, 0x91, 0xc4, 0x57, 0x45, 0x1d, 0x81, 0x62, 0x2c, 0x04, 0xc1, 0xdc, 0xd3,
	0xb1, 0x64, 0x9a, 0x98, 0x5d, 0xf9, 0xe9, 0x48, 0x9c, 0x45, 0x30, 0xf5, 0x73, 0x18, 0xd1, 0xb0,
	0x4d, 0x8f, 0xf0, 0xd5, 0xec, 0x10, 0x82, 0x72, 0x3b, 0xbd, 0x60, 0xea, 0x8f, 0x0a, 0x14, 0x37,
	0xc5, 0x9a, 0x61, 0x93, 0x06, 0x31, 0xf8, 0x65, 0xef, 0xc4, 0x2a, 0xe4, 0x4d, 0x4e, 0x24, 0xe6,
	0xc4, 0x98, 0xca, 0xcd, 0xe4, 0x66, 0x4b, 0x8b, 0x77, 0xb3, 0x4e, 0xe5, 0xb2, 0x8f, 0xa7, 0x8e,
	0xd6, 0x72, 0x55, 0x25, 0x94, 0xe2, 0x31, 0x0a, 0x86, 0x6e, 0x43, 0xc1, 0x2d, 0xae, 0xc0, 0x14,
	0x94, 0x17, 0x90, 0x16, 0x08, 0x2d, 0xb5, 0x9d, 0xc5, 0x73, 0xcd, 0x1b, 0x1e, 0xdb, 0xa7, 0x30,
	0xbd, 0x61, 0x70, 0x6b, 0x05, 0x37, 0xb0, 0xf4, 0xd2, 0x5e, 0x31, 0xa4, 0x91, 0xa9, 0x8e, 0x26,
	0x61, 0x90, 0x08, 0xdd, 0xa1, 0x94, 0x05, 0x4d, 0xfb, 0x00, 0x11, 0xcf, 0x28, 0x65, 0xea, 0xeb,
	0x3e, 0xa8, 0x24, 0xf1, 0x09, 0x46, 0x1d, 0x81, 0xd1, 0xbf, 0x60, 0x98, 0xd3, 0x63, 0xa1, 0x5b,
	0xde, 0xb0, 0x15, 0xdc, 0xdb, 0x05, 0xd7, 0xe6, 0x7b, 0x58, 0xe8, 0x3f, 0x30, 0x12, 0x04, 0xdc,
	0x42, 0xf9, 0x92, 0xb0, 0x14, 0x98, 0x43, 0xe0, 0x3a, 0xcc, 0x84, 0x2f, 0xc8, 0xe0, 0x00, 0xea,
	0x3c, 0x50, 0x93, 0x2d, 0x4f, 0xbf, 0xb7, 0xb9, 0x99, 0xdc, 0x1e, 0x85, 0x44, 0x26, 0xd4, 0x52,
	0x89, 0xf6, 0x39, 0xb5, 0x75, 0x21, 0xb9, 0xe1, 0xd4, 0x31, 0x8f, 0x78, 0xfb, 0x3c, 0xde, 0xb9,
	0x64, 0xde, 0x35, 0x4e, 0xed, 0xed, 0xd0, 0x25, 0x16, 0x6d, 0xf8, 0x7e, 0x4d, 0x8d, 0xb6, 0xdf,
	0x8f, 0x36, 0x59, 0x21, 0x87, 0x44, 0x3a, 0x2c, 0xa4, 0x12, 0x49, 0x9a, 0x10, 0xeb, 0x80, 0xc7,
	0x3a, 0x9b, 0xcc, 0xba, 0x43, 0x4f, 0x45, 0x7a, 0x07, 0x4a, 0x7b, 0x0d, 0x6a, 0xbe, 0x88, 0x18,
	0x06, 0x3d, 0x86, 0xa2, 0x6f, 0x0d, 0x61, 0xf3, 0x80, 0x3c, 0x03, 0xb6, 0xf4, 0xbd, 0x97, 0x2d,
	0x68, 0xde, 0x83, 0x96, 0x83, 0x91, 0xc7, 0x2f, 0x03, 0xf4, 0x5c, 0x0d, 0x8a, 0x6d, 0x7d, 0x0a,
	0x2a, 0xc0, 0xe0, 0xca, 0xea, 0xda, 0xd2, 0xee, 0x93, 0x9d, 0x72, 0x0f, 0x1a, 0x84, 0xdc, 0xd2,
	0xf6, 0x72, 0x59, 0x41, 0x79, 0xe8, 0x5b, 0x59, 0xdd, 0x5e, 0x2e, 0xf7, 0xce, 0x7d, 0xd7, 0x0b,
	0x43, 0xad, 0x6a, 0x45, 0x63, 0x50, 0xde, 0x75, 0x5e, 0x38, 0xf4, 0xd8, 0x69, 0xd9, 0xca, 0x3d,
	0x68, 0x14, 0x46, 0xfc, 0x6c, 0x22, 0xa3, 0x82, 0xca, 0x30, 0xfc, 0x94, 0xc6, 0x2c, 0xbd, 0x2e,
	0x6c, 0xd5, 0x22, 0x92, 0xf2, 0xc8, 0x98, 0x43, 0xd3, 0x30, 0xbe, 0x61, 0x88, 0x8f, 0x0e, 0x88,
	0x60, 0x98, 0xe3, 0x18, 0xbe, 0x0f, 0x21, 0x28, 0x6d, 0x4b, 0x63, 0x7f, 0x3f, 0xb2, 0xf5, 0xbb,
	0xb6, 0x25, 0xcb, 0x26, 0xb1, 0xe9, 0x07, 0xd0, 0x04, 0xa0, 0xf5, 0x06, 0xdd, 0x33, 0x1a, 0x6d,
	0xf3, 0x0d, 0xa2, 0x71, 0xb8, 0xb6, 0x46, 0x1b, 0x0d, 0x7a, 0x8c, 0x63, 0x33, 0xe6, 0xdd, 0x1c,
	0xb6, 0x0c, 0x2e, 0x9d, 0xb8, 0x75, 0x08, 0x4d, 0xc2, 0xe8, 0x76, 0x73, 0x4f, 0x98, 0x9c, 0xec,
	0xc5, 0x07, 0xc0, 0xcd, 0xe3, 0xc3, 0xcd, 0xad, 0xc8, 0x52, 0x58, 0xfc, 0x69, 0x04, 0x06, 0x03,
	0x51, 0x80, 0x8e, 0xa1, 0xd4, 0xfe, 0x8d, 0x09, 0x65, 0x2a, 0x81, 0x53, 0x9f, 0xd1, 0x2a, 0x8b,
	0xe7, 0x75, 0x11, 0x0c, 0xfd, 0xa0, 0x78, 0x3a, 0x25, 0xf9, 0x1b, 0x07, 0x7a, 0xd4, 0x05, 0x63,
	0xea, 0xc7, 0x9d, 0xca, 0xfb, 0x6f, 0xe0, 0x1d, 0x85, 0x96, 0xdc, 0xd3, 0x76, 0x15, 0x5a, 0x6a,
	0x33, 0xdf, 0x55, 0x68, 0x67, 0x34, 0xd3, 0xaf, 0xa0, 0xdc, 0xd9, 0x39, 0xa1, 0xfb, 0x5d, 0x50,
	0x76, 0x36, 0x8b, 0x95, 0xff, 0x9f, 0xdf, 0x49, 0xb0, 0xa0, 0x5a, 0x62, 0xea, 0xb9, 0xab, 0x6a,
	0x69, 0xd7, 0xe6, 0x5d, 0x55, 0x4b, 0xa7, 0x40, 0x7f, 0x05, 0xe5, 0x4e, 0xf1, 0x9f, 0x9d, 0x77,
	0x42, 0x7b, 0x91, 0x9d, 0x77, 0x52, 0x8f, 0x81, 0xbe, 0x56, 0x60, 0x34, 0x41, 0xa4, 0xa3, 0xb7,
	0xb2, 0x55, 0x73, 0x52, 0xff, 0x50, 0x79, 0xfb, 0x42, 0x7e, 0x82, 0xa1, 0x6f, 0x15, 0x18, 0x4f,
	0x54, 0xf7, 0xe8, 0x9d, 0xae, 0x36, 0x34, 0xa1, 0x93, 0xa8, 0x3c, 0xbc, 0xa0, 0xa7, 0x60, 0xe8,
	0xb5, 0x02, 0x53, 0x69, 0x0a, 0x1a, 0xbd, 0x97, 0xc5, 0x7b, 0x86, 0xcc, 0xaf, 0x3c, 0xba, 0xb8,
	0xb3, 0x60, 0x08, 0x43, 0x3e, 0x54, 0xd7, 0xe8, 0x5e, 0x66, 0xdb, 0x1c, 0x49, 0xfc, 0xca, 0x7c,
	0xf7, 0x60, 0xc1, 0xd0, 0x01, 0x0c, 0xb5, 0x34, 0x31, 0xca, 0x74, 0x8d, 0x2b, 0xf8, 0xca, 0xc2,
	0x39, 0xd0, 0x41, 0x01, 0x26, 0xe8, 0xe0, 0xec, 0x02, 0x4c, 0x96, 0xe8, 0xd9, 0x05, 0x98, 0x22,
	0xba, 0xd1, 0xa1, 0xdb, 0xc5, 0x47, 0xaa, 0x18, 0xd5, 0xb2, 0x2b, 0xb9, 0x4d, 0xa2, 0x57, 0xfe,
	0x7b, 0x3e, 0x07, 0xc1, 0xd0, 0x0b, 0x80, 0x48, 0xcf, 0xa2, 0x85, 0x2e, 0x76, 0x28, 0xd2, 0xe7,
	0x95, 0xea, 0x79, 0xe0, 0x82, 0xa1, 0x6f, 0x14, 0x40, 0xa7, 0x75, 0x27, 0xca, 0x3c, 0x23, 0xa9,
	0xda, 0xb7, 0xf2, 0xee, 0x45, 0x5c, 0x7d, 0x99, 0xfb, 0xf8, 0xde, 0xa7, 0x77, 0xbb, 0xfe, 0x1f,
	0xdc, 0xde, 0x80, 0xf7, 0x35, 0xf1, 0xfe, 0x1f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x54, 0x9e, 0xf6,
	0x0b, 0xb7, 0x1b, 0x00, 0x00,
}
