package v1

// GetLiveFeaturedChannelsRequestParams contains required parameters
// for making a GET /v1/teams/:team_id/live_featured_channels request.
type GetLiveFeaturedChannelsRequestParams struct {
	TeamID string // route
	Limit  uint
}

// GetLiveFeaturedChannelsResponse is the response body of the
// GET /v1/teams/:team_id/live_featured_channels API.
type GetLiveFeaturedChannelsResponse struct {
	Data []GetLiveFeaturedChannelsData `json:"data"`
}

// GetLiveFeaturedChannelsData is a single unit of GetLiveFeaturedChannelsResponse.Data.
type GetLiveFeaturedChannelsData struct {
	ChannelID string `json:"channel_id"`
	TeamID    string `json:"team_id"`
}
