package v1

// PostTeamInvitationsRequestParams is the required request
// parameters of the POST /v1/teams/:team_id/invitations API.
type PostTeamInvitationsRequestParams struct {
	TeamID    string
	ChannelID string
}

// PostTeamInvitationsRequestBody is the required request body
// of the POST /v1/teams/:team_id/invitations API.
type PostTeamInvitationsRequestBody struct {
	ChannelID string `json:"channel_id"`
}

// PostTeamInvitationsResponse is the response body of the
// POST /v1/teams/:team_id/invitations API.
type PostTeamInvitationsResponse struct {
	Data PostTeamInvitationsData `json:"data"`
}

// PostTeamInvitationsData is a newly created invitation.
type PostTeamInvitationsData struct {
	TeamID    string `json:"team_id"`
	ChannelID string `json:"channel_id"`
}
