package roster

import (
	"context"

	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) GetV1ChannelMemberships(ctx context.Context, params v1.GetChannelMembershipsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetChannelMembershipsResponse, error) {
	path := fmt.Sprintf("/v1/channels/%s/memberships", params.ChannelID)
	response := &v1.GetChannelMembershipsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_channel_memberships",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
