package roster

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1TeamLiveMemberships makes a GET request to the Roster Service for
// a given team's live members.
func (c *clientImpl) GetV1TeamLiveMemberships(ctx context.Context, params v1.GetTeamLiveMembershipsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetTeamLiveMembershipsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/live_memberships", params.TeamID)
	response := &v1.GetTeamLiveMembershipsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_team_live_memberships",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
