package roster

import (
	"context"
	"net/http"
	"strconv"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1Teams makes a GET request to the Roster Service for teams.
func (c *clientImpl) GetV1Teams(ctx context.Context, params v1.GetTeamsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetTeamsResponse, error) {
	path := "/v1/teams"
	response := &v1.GetTeamsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_teams",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	query := req.URL.Query()

	if params.Limit != 0 {
		query.Set("limit", strconv.FormatUint(uint64(params.Limit), 10))
	}

	if params.Name != "" {
		query.Set("name", params.Name)
	}

	if params.Offset != 0 {
		query.Set("offset", strconv.FormatUint(uint64(params.Offset), 10))
	}

	if params.Sort != "" {
		query.Set("sort", string(params.Sort))
	}

	if params.UserID != "" {
		query.Set("user_id", params.UserID)
	}

	req.URL.RawQuery = query.Encode()

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
