# Changelog
All notable changes to the EventBus Client will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.2.0] - 2019-10-31

### Added
- Provide a low-level publisher package for people who want to do custom/bespoke eventbus.

### Changed
- STS regional endpoints are used for both Publisher and Subscriber clients by default

## [1.1.0] - 2019-08-26

### Added
- Publisher attaches [a few SNS attributes](docs/message_attributes.md) for potential use in the future
- Publisher sends no-op message(s) at `publisher.New` time to ensure the publisher has permissions to publish to the topic(s)
- Mux/Dispatcher changes:
  * User can override the behavior when no-op messages are received.
  * User can override how messages for unregistered handlers are handled.

### Changed
- Cleaned up mock publisher to be easier to make use of.
- Publisher fetches event stream routes over HTTPS (formerly http)

## [1.0.0] - 2019-07-30

First semver-adhering release of eventbus client.

### Changed
- Client assumes roles for both publishing and subscribing

### Removed
- Removed many old deprecated items, such as dispatch packaged

[1.2.0]: https://git-aws.internal.justin.tv/eventbus/client/compare/v1.1.0...v1.2.0
[1.1.0]: https://git-aws.internal.justin.tv/eventbus/client/compare/v1.0.0...v1.1.0
[1.0.0]: https://git-aws.internal.justin.tv/eventbus/client/compare/v0.2.0...v1.0.0
