package log

// ChannelLogger creates a logger that sends log messages to a channel.  It's useful for testing and buffering
// logs.
type ChannelLogger struct {
	Out    chan []interface{}
	OnFull Logger
}

func (c *ChannelLogger) logBlocking(kvs ...interface{}) {
	c.Out <- append(make([]interface{}, 0, len(kvs)), kvs...)
}

func (c *ChannelLogger) logNonBlocking(kvs ...interface{}) {
	select {
	case c.Out <- append(make([]interface{}, 0, len(kvs)), kvs...):
	default:
		c.OnFull.Log(kvs...)
	}
}

// Log blocks adding kvs to it's buffer.  If OnFull is not nil, it does not block.
func (c *ChannelLogger) Log(kvs ...interface{}) {
	if c.OnFull != nil {
		c.logNonBlocking(kvs...)
		return
	}
	c.logBlocking(kvs...)
}

func DrainChannel(into Logger, toDrain chan []interface{}, closeSignal chan struct{}) {
	for {
		select {
		case <-closeSignal:
			return
		case msgs := <-toDrain:
			into.Log(msgs...)
		}
	}
}
