package eventbus

import (
	"context"

	"github.com/golang/protobuf/ptypes/wrappers"
	"github.com/twitchtv/twirp"

	"code.justin.tv/eventbus/schema/pkg/user"
)

type EventBusProcessor interface {
	ProcessUserDestroy(ctx context.Context, event *user.UserDestroy, cursor *wrappers.StringValue) (*ConsumeEventResponse, error)
}

type defaultProcessor struct {
}

func NewDefaultEventBusProcessor() EventBusProcessor {
	return &defaultProcessor{}
}

func (p *defaultProcessor) ProcessUserDestroy(ctx context.Context, event *user.UserDestroy, cursor *wrappers.StringValue) (*ConsumeEventResponse, error) {
	return nil, twirp.NewError(twirp.Unimplemented, "ProcessUserDestroy is unimplemented")
}
