# What is this?

This is a starter project built with `create-react-app` + `twitch-core-ui`. You can use it to:

1. Build quick prototypes using existing Core UI components.
2. Create new components which can be then migrated to another project such as Core UI or Twilight. 
3. Re-create and debug complex layout issues in a clean issolated environment. 


# Steps to set up

1. Clone repository
2. run `yarn install`
4. run `yarn start`
5. Edit `src/App.tsx` and start prototyping things with core-ui!

### Optinal Steps to link local core-ui repo

1. Clone Core UI repository
2. Run `yarn link` in local directory
3. Run `yarn link twitch-core-ui` in local prototype directory
4. `yarn && yarn start` in prototype to use local core-ui!

# Deployment / Sharing

You can deploy to Github Pages with these steps:

1. Fork this project on Github so you have your own repository, then clone locally.
2. Edit `package.json` and change the "homepage" value to match your github username, and repository name. For example: `https://git-aws.internal.justin.tv/pages/{USER_NAME}/{REPO_NAME}/`
3. Run `yarn deploy`.
4. Celebrate, then share the homepage URL you set in step 2

Running `yarn deploy` will first create a `build` folder, then it will commit and push it to a branch named `gh-pages`. By default you will be able to see that branch on Github pages for your project! If not, check your repo settings for Github Pages configuration. You must still separately commit your changes to `master`. 


---

*The deployment process [uses the gh-pages tool](https://github.com/facebook/create-react-app/blob/master/packages/react-scripts/template/README.md#github-pages).*

*This project was bootstrapped with [Create React App Typescript](https://github.com/wmonk/create-react-app-typescript).*
