import * as React from 'react';
import { HashRouter as Router, Route, Switch } from 'react-router-dom';
import { Align, AlignContent, AlignItems, AlignSelf, Animation, AnimationDelay, AnimationDuration, AnimationFillMode, AnimationTiming, AnimationType, Aspect, AspectRatio, Avatar, AvatarSize, Background, Badge, BadgeType, Balloon, BalloonDirection, BalloonSize, BorderRadius, BoxArtCard, Button, ButtonIcon, ButtonIconType, ButtonSize, ButtonState, ButtonType, Card, CardBody, CardImage, CardImageSize, ChannelStatusIndicator, ChannelStatusIndicatorSize, ChannelStatusIndicatorStatus, CheckBox, Color, Column, CoreImage, CoreImageSize, CoreLink, CoreLinkType, CoreSrcSet, CoreText, Display, DropZone, FlexDirection, FlexWrap, FontSize, FormGroup, FormGroupOrientation, getDataProps, Grid, GridGutterSize, InjectLayout, InjectStyledLayout, Input, InputType, Interactable, JustifyContent, Layout, LineHeight, LoadingSpinner, Overflow, Pill, PillType, Placeholder, Position, Presence, PresenceStatus, ProgressBar, ProgressBarSize, ProgressBarStatus, Radio, Range, Resize, SearchInput, SegmentedButton, SegmentedButtonOption, Select, Sorting, SpinnerSize, Stat, StyledLayout, SVG, SVGAsset, SVGType, Tab, Table, TableBody, TableCell, TableHeader, TableHeading, TableRow, TabWrapper, Tag, TextAlign, TextArea, TextDecoration, TextTransform, TextType, ThumbnailCard, Toast, Toggle, Tooltip, TooltipAlign, TooltipDirection, Tower, TowerChildWidth, TowerGutter, Typeset, VerticalAlign, Visibility, WordBreak, ZIndex } from 'twitch-core-ui';
import { NavBar } from 'ui-prototype-tool/components/nav-bar';
import { AboutPage } from './pages/about';
import { ContactPage } from './pages/contact';
import { HomePage } from './pages/home';

import './App.sass';

export class App extends React.Component<{}, {}> {
  public render() {
    return (
      <StyledLayout background={Background.Alt2} fullHeight>
        <StyledLayout className="team-background-image" fullHeight padding={{ bottom: 3 }}>
        
        <Layout padding={{ bottom: 3 }}>
          <NavBar />
        </Layout>

        <Layout display={Display.Flex} justifyContent={JustifyContent.Center} padding={{ left: 3, right: 3 }}>

          <StyledLayout className="team-container" background={Background.Base} elevation={3} display={Display.Flex} padding={2}>
            <Layout className="team-column--left" display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
            {/* <Placeholder 
              height={250}
              width={250}
            /> */}
              <Layout flexGrow={0} flexShrink={1}>
                <img src="https://static-cdn.jtvnw.net/jtv_user_pictures/team-navi-team_logo_image-061d13490aaccda9-600x600.jpeg" />
              </Layout>
              <StyledLayout display={Display.Flex} padding={{ y: 1 }}>
                <Layout alignItems={AlignItems.Start} display={Display.Flex} flexGrow={1}>
                  <CoreText color={Color.Base}>Team Members</CoreText>
                </Layout>
                <Layout display={Display.Flex} alignItems={AlignItems.End}>
                  <CoreText color={Color.Base}>453</CoreText>
                </Layout>
              </StyledLayout>

              <StyledLayout className="team-member-list" border display={Display.Flex} flexDirection={FlexDirection.Column} flexGrow={1} overflow={Overflow.Hidden} position={Position.Relative}>
                <StyledLayout overflow={Overflow.Auto}>
                  <Grid>
                    <Column cols={12}>
                      <StyledLayout className="team-member--active">
                        <Interactable>
                          <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                            <Layout flexGrow={0} flexShrink={0}>
                              <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                            </Layout>
                            <Layout padding={{ left: 1 }} flexGrow={1}>
                              <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                            </Layout>
                            <Layout display={Display.Flex} alignItems={AlignItems.End}>
                              <Layout margin={{ right: .5 }}>
                                <ChannelStatusIndicator status={ChannelStatusIndicatorStatus.Live} pulse />
                              </Layout>
                            </Layout>
                          </StyledLayout>
                        </Interactable>
                      </StyledLayout>
                    </Column>
                    <Column cols={12}>
                      <StyledLayout className="team-member--live">
                        <Interactable>
                          <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                            <Layout flexGrow={0} flexShrink={0}>
                              <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                            </Layout>
                            <Layout padding={{ left: 1 }} flexGrow={1}>
                              <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                            </Layout>
                            <Layout display={Display.Flex} alignItems={AlignItems.End}>
                              <Layout margin={{ right: .5 }}>
                                <ChannelStatusIndicator status={ChannelStatusIndicatorStatus.Live} pulse />
                              </Layout>
                            </Layout>
                          </StyledLayout>
                        </Interactable>
                      </StyledLayout>
                    </Column>
                    <Column cols={12}>
                      <StyledLayout className="team-member--live">
                        <Interactable>
                          <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                            <Layout flexGrow={0} flexShrink={0}>
                              <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                            </Layout>
                            <Layout padding={{ left: 1 }} flexGrow={1}>
                              <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                            </Layout>
                            <Layout display={Display.Flex} alignItems={AlignItems.End}>
                              <Layout margin={{ right: .5 }}>
                                <ChannelStatusIndicator status={ChannelStatusIndicatorStatus.Live} pulse />
                              </Layout>
                            </Layout>
                          </StyledLayout>
                        </Interactable>
                      </StyledLayout>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    <Column cols={12}>
                      <Interactable>
                        <StyledLayout alignItems={AlignItems.Center} display={Display.Flex} flexGrow={1} padding={1}>  
                          <Layout flexGrow={0} flexShrink={0}>
                            <Avatar alt="username avatar" size={36} src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png" />
                          </Layout>
                          <Layout padding={{ left: 1 }} flexGrow={1}>
                            <CoreText color={Color.Base} fontSize={FontSize.Size5}>Molu</CoreText>
                          </Layout>
                          <Layout display={Display.Flex} alignItems={AlignItems.End}>
                            <Layout margin={{ right: .5 }}>
                            </Layout>
                          </Layout>
                        </StyledLayout>
                      </Interactable>
                    </Column>
                    {/* Added a final column here so that the Back to Top won't prevent users from selecting the last member in the list */}
                    <Column cols={12}>
                      <Layout margin={{ y: 3 }}>
                      </Layout>
                    </Column>
                  </Grid>
                </StyledLayout>
                <StyledLayout attachBottom background={Background.Overlay} fullWidth position={Position.Absolute}>
                  <Interactable>
                    <StyledLayout padding={.5} textAlign={TextAlign.Center}>
                      Back to Top
                    </StyledLayout>
                  </Interactable>
                </StyledLayout>
              </StyledLayout>
            </Layout>
            
            <Layout className="team-column--right">
              <StyledLayout textAlign={TextAlign.Center}>
                <img className="team-banner-image" src="https://static-cdn.jtvnw.net/jtv_user_pictures/team-navi-banner_image-0752d717f87d742f-640x125.jpeg" alt=""/>
              </StyledLayout>
              <StyledLayout className="team-description-container" margin={{ top: 1 }} overflow={Overflow.Hidden}>
                <CoreText type={TextType.H4} bold color={Color.Base}>Natus Vincere</CoreText>
                <StyledLayout className="team-description-gradient team-description-gradient--light" position={Position.Absolute}>
                </StyledLayout>
                <CoreText color={Color.Base}>
                  Developer Day will be held on October 19 in Long Beach, CA, one day prior to TwitchCon. Game creators and stream tools developers of all levels, from hobbyists to AAA studios, are invited to learn more about the Twitch Developer Platform, hear directly from the people behind the products, and share experiences with each other. Game creators and stream tools developers of all levels, from hobbyists to AAA studios, are invited to learn more about the Twitch Developer Platform, hear directly from the people behind the products, and share experiences with each other. Game creators and stream tools developers of all levels, from hobbyists to AAA studios, are invited to learn more about the Twitch Developer Platform, hear directly from the people behind the products, and share experiences with each other.
                </CoreText>
              </StyledLayout>
              <Layout margin={{ bottom: 1 }} textAlign={TextAlign.Right}>
                <CoreLink>See more</CoreLink>
              </Layout>
             
              <StyledLayout
                alignItems={AlignItems.Center}
                border
                padding={1}
                display={Display.Flex}
              >
                <Layout>
                  <CoreLink>
                    <Avatar
                      alt="Demo alt text"
                      size={64}
                      src="https://static-cdn.jtvnw.net/jtv_user_pictures/61944a30-9184-4994-9046-02613b750da7-profile_image-70x70.png"
                    />
                  </CoreLink>
                </Layout>
                <Layout flexGrow={1} margin={{ x: 1 }} overflow={Overflow.Hidden}>
                  <CoreText fontSize={FontSize.Size4} ellipsis title="Streamer_Username_asfasdfasdf_asfas_fasdf_asd_asdfasf_asdasf_asfdasdfasfas_fasfd">
                    <CoreLink to="https://twitch.tv">
                      Streamer_Username_asfasdfasdf_asfas_fasdf_asd_asdfasf_asdasf_asfdasdfasfas_fasfd
                    </CoreLink>
                  </CoreText>
                  
                  <Layout display={Display.InlineFlex}>
                    <Layout margin={{ right: 1, top: .5 }}>
                      <CoreText color={Color.Live}>
                        <Stat
                          label="Viewers"
                          value="11,239"
                          icon={SVGAsset.GlyphLive}
                          tooltipAlign={TooltipAlign.Center}
                          tooltipDirection={TooltipDirection.Top}
                        />
                      </CoreText>
                    </Layout>
                    <Layout margin={{ right: 1, top: .5 }}>
                      <CoreText color={Color.Alt2}>
                        <Stat
                          label="Followers"
                          value="3,109"
                          icon={SVGAsset.GlyphFollowers}
                          tooltipAlign={TooltipAlign.Center}
                          tooltipDirection={TooltipDirection.Top}
                        />
                      </CoreText>
                    </Layout>
                    <Layout margin={{ right: 1, top: .5 }}>
                      <CoreText color={Color.Alt2}>
                        <Stat
                          label="Views"
                          value="62,985"
                          icon={SVGAsset.GlyphViews}
                          tooltipAlign={TooltipAlign.Center}
                          tooltipDirection={TooltipDirection.Top}
                        />
                      </CoreText>
                    </Layout>
                  </Layout>
                </Layout>

                <Layout padding={{ right: 1 }}>
                <Layout position={Position.Relative}>
                  {/* Add show to Balloon to see balloon, the balloon should appear when user clicks "Info" button */}
                    <Balloon
                      direction={BalloonDirection.TopRight}
                      size={BalloonSize.Medium}
                    >
                      <Layout padding={1}>
                        <CoreText color={Color.Base}>
                          Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas fermentum mauris ut dignissim finibus. Aliquam venenatis diam sem, vitae sodales nunc fermentum at. Cras eget erat sit amet nisi fringilla feugiat. Nulla et lorem eget nibh ornare euismod. Nam auctor neque sed libero varius, vitae rhw
                        </CoreText>
                      </Layout>
                    </Balloon>
                  </Layout>
                  <Button>Info</Button>
                  
                </Layout>
                <Layout flexGrow={0} flexShrink={0} padding={0}>
                  <Button>Subscribe</Button>
                </Layout>
              </StyledLayout>
              <StyledLayout background={Background.AccentAlt2}>
                <Aspect ratio={AspectRatio.Aspect16x9}>
                </Aspect>
              </StyledLayout>

              <StyledLayout
                alignItems={AlignItems.Center}
                border
                display={Display.Flex}
                padding={1}
              >
                <StyledLayout className="team-channel-boxart" background={Background.Accent} flexGrow={0} flexShrink={0}>
                  <img src="https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-80x106.jpg" alt="boxart"/>
                </StyledLayout>

                <Layout margin={{ x: 1 }} overflow={Overflow.Hidden}>
                  <Layout margin={{ bottom: .5 }}>
                    <CoreText color={Color.Base} fontSize={FontSize.Size5} ellipsis={true} title="Stream title that is pretty long, but not maximum character limit asfasd fas fas fas df asfasdfasdf ">
                      Stream title that is pretty long, but not maximum character limit asfasd fas fas fas df asfasdfasdf 
                    </CoreText>
                  </Layout>
                  <Layout display={Display.Flex} flexWrap={FlexWrap.Wrap}>
                    <Layout alignItems={AlignItems.Center} display={Display.Flex} margin={{ right: 1 }}>
                      <Layout display={Display.InlineFlex}>
                        <Layout margin={{ right: .5 }}>
                          <StyledLayout alignItems={AlignItems.Center} color={Color.Alt2} display={Display.Flex} fontSize={FontSize.Size5}>
                            <SVG asset={SVGAsset.NavGames} /> 
                          </StyledLayout>
                        </Layout>
                        <CoreText ellipsis fontSize={FontSize.Size5}>
                          <CoreLink to="https://www.twitch.tv/directory/game/Overwatch">Overwatch</CoreLink>
                        </CoreText>
                      </Layout>
                    </Layout>

                    <Layout alignItems={AlignItems.Center} display={Display.Flex} margin={{ right: 1 }}>
                      <Layout display={Display.InlineFlex}>
                        <Layout margin={{ right: .5 }}>
                          <StyledLayout alignItems={AlignItems.Center} color={Color.Alt2} display={Display.Flex}>
                            <SVG asset={SVGAsset.Team} />
                          </StyledLayout>
                        </Layout>
                        <CoreText ellipsis fontSize={FontSize.Size5}>
                          <CoreLink to="https://www.twitch.tv/team/navi">Natus Vincere</CoreLink>
                        </CoreText>
                      </Layout>
                    </Layout>
                    <Layout alignItems={AlignItems.Center} display={Display.Flex} margin={{ right: 1 }}>
                      <Layout display={Display.InlineFlex}>
                        <Layout margin={{ right: .5 }}>
                          <StyledLayout alignItems={AlignItems.Center} color={Color.Alt2} display={Display.Flex}>
                            <SVG asset={SVGAsset.Communities} />
                          </StyledLayout>
                        </Layout>
                        <CoreText ellipsis fontSize={FontSize.Size5}>
                          <Layout display={Display.InlineFlex} margin={{ right: .5 }}>
                            <CoreLink to="https://www.twitch.tv/communities/positivity">Positivity</CoreLink>,
                          </Layout>
                          <Layout display={Display.InlineFlex} margin={{ right: .5 }}> 
                            <CoreLink to="https://www.twitch.tv/communities/overwatch">Overwatch</CoreLink>
                          </Layout>
                        </CoreText>
                      </Layout>
                    </Layout>
                  </Layout>
                </Layout>

                <Layout>
                  <Button type={ButtonType.Hollow}>
                    <span className="tw-button__icon tw-button__icon--left tw-pd-0 tw-pd-r-05">
                      <SVG asset={SVGAsset.Share} />
                    </span>
                    <span className="tw-button__text tw-pd-0">
                      Share
                    </span>
                    </Button>
                </Layout>
              </StyledLayout>
            </Layout>
          </StyledLayout>
        </Layout >;
      </StyledLayout>
      </StyledLayout >
    );
  }
}



