import * as React from 'react';
import {
  Animation,
  AnimationDuration,
  AnimationType,
  Background,
  CoreText,
  Display,
  FontSize,
  JustifyContent,
  Layout,
  StyledLayout,
  TextType,
} from 'twitch-core-ui';

export class BreakpointIndicator extends React.Component<{}, {}> {
  public render() {
    return (
      <StyledLayout padding={2} background={Background.Alt2} display={Display.Flex} justifyContent={JustifyContent.Center}>

        <Layout
          display={Display.Block}
          breakpointExtraSmall={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Default')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointExtraSmall={{
            display: Display.Block,
          }}
          breakpointSmall={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Extra Small (xs)')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointSmall={{
            display: Display.Block,
          }}
          breakpointMedium={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Small (sm)')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointMedium={{
            display: Display.Block,
          }}
          breakpointLarge={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Medium (md)')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointLarge={{
            display: Display.Block,
          }}
          breakpointExtraLarge={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Large (lg)')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointExtraLarge={{
            display: Display.Block,
          }}
          breakpointExtraExtraLarge={{
            display: Display.Hide,
          }}
        >
          {this.renderLabel('Extra Large (xl)')}
        </Layout>

        <Layout
          display={Display.Hide}
          breakpointExtraExtraLarge={{
            display: Display.Block,
          }}
        >
          {this.renderLabel('Extra Extra Large (xxl)')}
        </Layout>

      </StyledLayout>
    );
  }

  private renderLabel(label: string) {
    return (
      <Layout>
        <CoreText type={TextType.Span} fontSize={FontSize.Size4}>
          Current Breakpoint:
        </CoreText>
        <Layout display={Display.InlineBlock} margin={{ left: 0.5 }}>
          <Animation
            enabled
            type={AnimationType.FadeIn}
            duration={AnimationDuration.Long}
          >
            <CoreText type={TextType.Span} fontSize={FontSize.Size4} bold>
              {label}
            </CoreText>
          </Animation>
        </Layout>
      </Layout>
    );
  }
}
