import * as React from 'react';
import { AlignItems, Background, Color, Display, JustifyContent, Layout, Placeholder, StyledLayout, SVG, SVGAsset } from 'twitch-core-ui';

export class NavBar extends React.Component<{}, {}> {
  public render() {
    return (
      <StyledLayout display={Display.Flex} alignItems={AlignItems.Center} justifyContent={JustifyContent.Between} background={Background.Accent} color={Color.Overlay} padding={1}>

        <Layout flexGrow={0} flexShrink={0}>
          <SVG asset={SVGAsset.LogoGlitch} width={26} height={26} />
        </Layout>

        <Layout flexGrow={0} flexShrink={0} display={Display.Flex} alignItems={AlignItems.Start}>
          <Layout>
            <Placeholder overlay width={30} height={30} />
          </Layout>
          <Layout padding={{ left: 0.5 }}>
            <Placeholder overlay width={200} height={14} />
            <Placeholder overlay lineCount={1} />
          </Layout>
        </Layout>

      </StyledLayout>
    );
  }
}
