# Instructions for setting up the server
## macOS Setup
### Prerequisites
- [Homebrew](https://brew.sh)

### Steps
1.  Open a terminal 
2.  ```sh
    brew install httpd php72 composer
    git clone https://git-aws.internal.justin.tv/twitch/TPM
    cd TPM/wpu
    composer update
    ```    
5.  There are 4 key and password `.example` files that you need to copy and remove that extension for the code to run
    ```
    google-7ed5d6ebdcae.json.example <-- Google Apps login credentials 
    jira-credentials.php.example <-- Jira login credentials
    mode-credentials.php.example <-- Mode Analytics login credentials
    privkey.pem.example <-- private key pair
    .env.example <-- App configuration
    ```
6.  Run `php artisan key:generate` to generate an application key
7. To run the server, run `php artisan serve` in the terminal and if it’s successful you will get a message that says
    >Laravel development server started: <[http://127.0.0.1:8000](http://127.0.0.1:8000)> 
8.  You should be able go to the browser and see the Twitch-wide WPU webpage by using the following URL
     ```
     http://127.0.0.1:8000/twitch/wpu
     ```
<br />

## Windows Setup

1.  Check which version of PHP you have by typing `php -v`
2.  Get PHP 7.2+ if you have something lower than that
3.  Install PHP with HTTPS by using XAMPP
    * Download link: [https://www.apachefriends.org/index.html](https://www.apachefriends.org/index.html) - There are a lot of things you don’t need, but it will streamline the windows installation
4.  Download and install composer which is a package dependency tool: [https://getcomposer.org/download/](https://getcomposer.org/download/) (requires SSL to be enabled for installer)
5.  From the command prompt, run all your commands with path prepended with this `c:\xampp\php\` 
    * Verify your installation worked `c:\xamp\php\php composer.phar`
6.  Get the entire repository https://git-aws.internal.justin.tv/twitch/TPM
7.  Extract to Document folder where you want the code to live
    `/Users/<username>/Documents/Twitch`
8.  Run `php composer.phar update` from within the **wpu** folder from the terminal to download the dependencies
    * If the paths aren't set correctly, use full path `C:\xampp\php\php C:\xampp\php\composer.phar update`
9.  To run the server, at the prompt: `php artisan serve`

<br />

## Getting Your Own Credential and Configuration Files
 1. `google-7ed5d6ebdcae.json` This file is needed if you wish to connect google sheets to read or write data.
    * The code is using an access token as documented here: https://developers.google.com/sheets/api/guides/authorizing
 2. `jira-credentials.php` This file is needed for connecting to Jira.
    * We're using a shared service account for all TPMs `srvc-jira-twitchtpm`.
 
 3. `mode-credentials.php` This file is needed if you wish to include Mode graphs in your report
    * Login into https://modeanalytics.com
    * Go to https://modeanalytics.com/settings and COMMUNITY > API Tokens
    * Create a New Access Token
    * Copy both Token string and Password string generated in your behalf
 4. `privkey.pem` This is required for SSL to work and is not specific to the TPM codebase.
    * Following instructions such as these will work: https://rietta.com/blog/openssl-generating-rsa-key-from-command/
 5. `.env` This is the main app configuration file and includes your Jira OAuth secrets and tokens along with email credentials if you want to automatically email out from the app.
 
    * To setup a Gmail app password for emailing out, follow the instructions listed here: https://support.google.com/mail/answer/185833?hl=en
     
     ```
     MAIL_DRIVER=smtp
     MAIL_HOST=smtp.googlemail.com
     MAIL_PORT=465
     MAIL_SUBJECT_PREPEND_TEST="[TEST] "
     MAIL_TO_TEST=justprogrammanagers@justin.tv,jonmlee@justin.tv,ravirani@justin.tv
     MAIL_TO=weekly-program-status@twitch.tv
     MAIL_FROM=jonmlee@justin.tv
     MAIL_USERNAME=jonmlee@justin.tv
     MAIL_PASSWORD=xxxxxxxxxxx
     MAIL_ENCRYPTION=ssl
     ```
    * You will be able to generate your own Twitch Jira OAuth1 credentials from the modified [Atlassian PHP OAuth Example](https://git-aws.internal.justin.tv/twitch/TPM/tree/master/oauth) codebase.
    * Open your terminal and navigate to <repo>/TPM/oauth
    * Run `composer update` to make sure the dependencies are downloaded
    * Navigate and change directory to <repo>/TPM/oauth/web
    * Run the embedded PHP web server `sudo php -S localhost:80`
    ```
    784f4396d69d:web jonmlee$ sudo php -S localhost:80
    Password:
    PHP 7.2.1 Development Server started at Tue Jun 25 16:29:44 2019
    Listening on http://localhost:80
    Document root is /Users/jonmlee/Documents/repo/TPM/oauth/web
    Press Ctrl-C to quit.
    [Tue Jun 25 16:29:53 2019] ::1:60658 [200]: /
    ```
    * Open the `http://localhost/` webpage in your web browser
    * `Click here to authenticate with Jira`  
    ![Step 1](./oauth/images/step1.png)
    * Click `Allow`  
    ![Step 2](./oauth/images/step2.png)
    * Copy and paste the `oauth_token` and `oauth_token_secret` into the `.env` file  
    ![Step 3](./oauth/images/step3.png)
     ```
     JIRA_HOST="https://jira.xarth.tv/"
     JIRA_USER="srvc-jira-twitchtpm"
     JIRA_PASS="xxxxxxxx"
     OAUTH_ACCESS_TOKEN="xxxxxxxx"
     JIRA_OAUTH_TOKEN="xxxxxxxx"
     JIRA_OAUTH_SECRET="xxxxxxxx"
     ```
    
    * If you need information from the Latency portal, you'll need a JWT token (https://jwt.io/) which you can get from the Latency team via Slack #latency-portal. They will give you the credential information via [1Password](https://wiki.twitch.com/display/HD/How+to+set+up+your+Twitch+1Password+Account).
     ````     
     LATENCY_JWT="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
     ```
    
 ## Deploying Code to the AWS Host
  * The host is located here: [https://weeklytpm.internal.justin.tv/](https://weeklytpm.internal.justin.tv/)
  * Please reference the [Deploying Code Doc](deploying-code.md)
  
## Code Structure
  * Please reference the [Code Structure Doc](code-structure.md)