# Code Structure and Making a Report
## Folder Tree

The code is written such that you can get a baseline report with just configuration changes. However, for more complex reports, the owner would have to write code to tailor to their needs. I will describe the main folder tree, the types of files it contains, and how it fits together. 

Once you pull the codebase, you will get the `TPM` tree with the `wpu` (weekly program update) being the main [Laravel app](https://laravel.com/) folder.

Each folder within the `config` folder represents a business unit and reports that it may hold; subfolders can exist to hold the underlying program reports. For example under `creator`, there are `costream`, `spotlight`, `streaming-analytics`, `sunlight`, and `ugc_esports`. There a few main config files and combined together will generate the full report.
```
burndowns.php -> For creating burndown graphs generated from jira data if you Jira project uses Fix Version Burndown or Epic Burndown reports. May burndown points or days.
jira.php -> Configure with JQL that you would use from the Jira Search page
projectinfo.php -> Input with high level info for the program like the name and also where Google sheet is located
contacts.php -> Input the information used for the footer of the report like contact information or wiki pages
```

  ![Configs](./readme-images/top-level-folder.png)

If you want to configure your report to your specific needs which most people want that control, you're going to need to create your own `controller` which in the MVC model has some logic around pulling all the pieces together to form a report like which `template` and which types of `data`.

```
GenericProject.php -> Generic project controller which can be extended for customization and offers lots of base functionality
Burndown.php -> This generates a JSON of burndown data used by the Google Charts library. Don't modify this.
Creator.php -> Creator Program update that pulls in all the subfolders to generate a single report. It extends the GenericProject.php class.
WPU.php -> Company-wide Weekly Program Update. Don't modify this.
WOR.php -> Weekly Operational Review. Don't modify this.
```
  ![Controllers](./readme-images/controllers.png)


The most important file in this folder is `web.php` as it configures how the routing works when you hit the [AWS host](https://weeklytpm.internal.justin.tv/). The file works top-down such that the items in the top have higher priority when it matches a pattern to use the `controller`.
  ![Routes](./readme-images/routes.png)
  
The `views` folder contains the [Blade templates](https://laravel.com/docs/5.8/blade) which are merely HTML files with special instruction to use variables to generate the page. Feel free to clone an existing one you like or use the `genericproject.blade.php`.  

  ![Templates](./readme-images/templates.png)
  
 ## Examples
 Twitch WPU (Weekly Program Update)
 ![WPU](./readme-images/twitch-wpu.png)
 
 Twitch PDP (Product Development Process)
 ![PDP](./readme-images/pdp.png)
 
 Creator Program Update
 ![Creator](./readme-images/creator-program.png)
 
 Sunlight Program Update (under the Creator Org)
 ![Sunlight](./readme-images/sunlight.png)
 
 Outdate Creator Experience Program -> pulls data from Mode
 ![CE](./readme-images/old-ce-program.png)
 
 Weekly Operational Review for Ads -> pulls data from latency portal, jira, Google Sheets
 ![WOR](./readme-images/wor.png)