# Deploying Code to AWS
## macOS

1. Be inside the TPM directory wherever you are cloned locally (e.g. /Users/jonmlee/Documents/repo/TPM)
2. Run the archiving zip command with the follow parameters
    1. -r = recursive directory
    2. tpm-aws-0.1.23.zip = name of the archive, which you should change and "../" means its archived outside of the TPM directory 
    3. -x = exclusions that are temporary or locally-required files that don't need to be part of the deploy
    ```
    $ zip -r ../tpm-aws-0.1.23.zip . -x "*.example" "*.git*" "wpu/.idea/*" "wpu/storage/framework/cache/data/*" "wpu/storage/logs/*"
    ```
3. Change directory to one level up from the TPM directory
    ```
    $ cd ..
    ```
4. View the directory listings sorted by time and the archive should be one of your most recent files
    ```
    $ ls -althr
    ```
5. (Optional) Compare past archive against the latest one. In this example, we're comparing "tpm-aws-0.1.22.zip" against "tpm-aws-0.1.23.zip" as far as file listings. It does not compare the contents of the files.
    ```
    diff -y -i -w -W 200 --suppress-common-lines <(unzip -lqq tpm-aws-0.1.22.zip | cut -c 29-120) <(unzip -lqq tpm-aws-0.1.23.zip | cut -c 30-120) | sort -b -f -k 4
    ```
    
## AWS Upload Steps
1. Login to the AWS Console via isengard (https://isengard.amazon.com/console-access)
2. You will be redirected to the AWS Console (https://us-west-2.console.aws.amazon.com/console/home?region=us-west-2#)
3. The code is deployed to the "Oregon" region
4. Load the Elastic Beanstalk Application Versions page (https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/versions?applicationName=WORTools)
5. Click "Upload" and fill out the required information
    1. Version label should follow the sequence and pattern established x.x.xx (e.g. 0.1.23)
    2. "Choose File" and pick the archive you created from above (e.g. tpm-aws-0.1.23.zip)
    3. Click "Upload" within the open modal
6. Check the checkbox on the left of the uploaded version and from "Actions" dropdown, select "Deploy"
7. It should take between 2-4 minutes
8. The dashboard page (https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=WORTools&environmentId=e-cmarjvyi7e) will provide you with the latest status
9. Check that the Weekly Program Update at https://weeklytpm.internal.justin.tv/twitch/wpu page is loading correctly
