<?php


class GoogleSheets
{
    //two column data
    //three column data -- key, name + email
    public static function getGSheetData($spreadsheetId = '1fQzC751RUlvBDkoBVtqH2ta-FQgi1N__kJ_aILDsnzQ', $range = 'Copy!A2:B100', $columns = 2)
    {
        putenv('GOOGLE_APPLICATION_CREDENTIALS=../../google-7ed5d6ebdcae.json');

        $client = new Google_Client();
        $client->useApplicationDefaultCredentials();
        $client->setScopes(Google_Service_Sheets::SPREADSHEETS_READONLY);
//        $user_to_impersonate = "jonmlee@twitch.tv";
//        $client->setSubject($user_to_impersonate);
//        dd($client);

        $service = new Google_Service_Sheets($client);
        $response = $service->spreadsheets_values->get($spreadsheetId, $range);

        $values = $response->getValues();
        $assocArray = array();

        foreach ($response->getValues() as $value) {
            if ($columns > 2) {
                if (isset($value[1])) {
                    for ($i = 1; $i < sizeof($value); $i++) {
                        $tempAry[] = $value[$i];
                    }
                    $assocArray[$value[0]] = $tempAry;
                }
            } else {
                if (isset($value[1])) {
                    $assocArray[$value[0]] = $value[1];
                }
            }
            $tempAry = array();
        }
        return $assocArray;
    }

    //use for grabbing a whole range of values
    public static function getRangeData($spreadsheetId = '1fQzC751RUlvBDkoBVtqH2ta-FQgi1N__kJ_aILDsnzQ', $range = 'Copy!A2:B100')
    {
        putenv('GOOGLE_APPLICATION_CREDENTIALS=../../google-7ed5d6ebdcae.json');
        $client = new Google_Client();
        $client->useApplicationDefaultCredentials();
        $client->setScopes(Google_Service_Sheets::SPREADSHEETS_READONLY);
        $service = new Google_Service_Sheets($client);
        $response = $service->spreadsheets_values->get($spreadsheetId, $range);
        return $response->values;
    }

    public static function getA1Notation($num)
    {
        $numeric = $num % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval($num / 26);
        if ($num2 > 0) {
            return self::getA1Notation($num2 - 1) . $letter;
        } else {
            return $letter;
        }
    }

}