<?php

class Helpers
{
    function __construct()
    {

    }

    public static function arrayCollapseSum($array)
    {
        $newArray = array();
        foreach ($array as $value) {
//            var_dump($value);
            foreach ($value as $status => $count) {
                if (!isset($newArray["$status"])) {
                    $newArray["$status"] = $count;
                } else {
                    $newArray["$status"] = $newArray["$status"] + $count;
                }
            }
        }
        krsort($newArray);
        return $newArray;
    }

    public static function search($array, $key, $value)
    {
        $results = array();

        if (is_array($array)) {
            if (isset($array[$key]) && $array[$key] == $value) {
                $results[] = $array;
            }

            foreach ($array as $subarray) {
                $results = array_merge($results, Helpers::search($subarray, $key, $value));
            }
        }
//        print_r ($results);
        return $results;
    }

    public static function findWhere($array, $matching)
    {
        foreach ($array as $item) {
            $is_match = true;
            foreach ($matching as $key => $value) {

                if (is_object($item)) {
                    if (!isset($item->$key)) {
                        $is_match = false;
                        break;
                    }
                } else {
                    if (!isset($item[$key])) {
                        $is_match = false;
                        break;
                    }
                }

                if (is_object($item)) {
                    if ($item->$key != $value) {
                        $is_match = false;
                        break;
                    }
                } else {
                    if ($item[$key] != $value) {
                        $is_match = false;
                        break;
                    }
                }
            }

            if ($is_match) {
                return $item;
            }
        }

        return false;
    }

    //Remove UTF8 Bom
    public static function remove_utf8_bom($text)
    {
        $bom = pack('H*', 'EFBBBF');
        $text = preg_replace("/^$bom/", '', $text);
        return $text;
    }

    //Create Random String for Nonce
    public static function makeRandomString($bits = 256)
    {
        $bytes = ceil($bits / 8);
        $return = '';
        for ($i = 0; $i < $bytes; $i++) {
            $return .= chr(mt_rand(0, 255));
        }
        return $return;
    }

    //for use with targets to make associative array
    public static function makeArrayFromCSV($filename = "", $delimiter = ",")
    {
        $csv = array_map('str_getcsv', file($filename));
        array_walk($csv, function (&$a) use ($csv) {
            $a = array_combine($csv[0], $a);
        });
        array_shift($csv); # remove column header
        return $csv;
    }

    //trim to string length, respecting last full word
    public static function word_limit($text, $stringLimit, $endString = "") {
        if(strlen($text) >= $stringLimit) {
            $pos = strpos($text, ' ', $stringLimit);
            return substr($text, 0, $pos) . $endString;
        } else {
            return $text;
        }
    }

    public static function convertStringtoLinks($string)
    {
        $reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,4}(\/\S*)?/";
        $replacement = "<a href=\"$0\">$0</a> ";
        $limit = 1000; //number of characters to limit on the Progress Status

        if (preg_match($reg_exUrl, $string, $url)) {
            // make the urls hyper links
            return nl2br(trim(Helpers::word_limit(preg_replace($reg_exUrl, $replacement, $string), $limit, "... ")));
        } else {
            // if no urls in the text just return the text
            return nl2br(trim(Helpers::word_limit($string, $limit, "... ")));
        }
    }

    // MEDIUM CONF -- 2-3 months out return month-year
    // LOW CONF -- > 3 months out return quarter-year
    // Carbon\Carbon::parse($issue->fields->duedate)->format('D, M d')
    public static function returnConfidenceDate($date, $mediumConf = 1, $lowConf = 3)
    {
        $duedate = Carbon\Carbon::parse($date);
        if ($duedate->diffInMonths($duedate->nowWithSameTz()) > $lowConf) {
            $quarter = ceil($duedate->month / 3);
            return $duedate->format("Q$quarter Y");
        } elseif ($duedate->diffInMonths($duedate->nowWithSameTz()) > $mediumConf) {
            return $duedate->format('M Y');
        } else {
            return $duedate->format('D, M d');
        }
    }

    //remove spaces
    public static function sanitize($text) {
        return preg_replace('/\s+/', '', $text);
    }

    //returns STL name and email from jiraKey and array
    //getting slack to work
    public static function returnSTL($jiraKey, $stlAry)
    {
        $re = '/[a-zA-Z]+/m';
        preg_match_all($re, $jiraKey, $matches, PREG_SET_ORDER, 0);
        $key = $matches[0][0];
        if(array_key_exists($key, $stlAry)) {
            $name = explode(" ", $stlAry[$key][0]);
            return '<a href="mailto:' . $stlAry[$key][1] . '">' . $name[0] . " " . $name[1][0] . ".</a>";
        } else {
            return "<i>TBD</i>";
        }
    }

    //returns slack icon + link to the project
    //data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAQCAYAAADwMZRfAAACRElEQVQ4jZWUXUiTYRTHf9vezX24za+NtUlrMrKQ1JJqEiZaYliEJAleRBcW1EVQeVMQ0UUX3tStXRgrjAi6iAxZdhHzopmYhWnhCHGi5Vc2t+Vscx9d5N58USL/N895zvPwP/9zzvMcWWt1F8Ax4ALgAhRAGinyAdmaHQRWgQGgA3gpAMeBp4CG/0Pe2noSqANOy4G2fxGcv+niRudRlCrFZscaoE0AyjIeuVxGbZOT5VCc/leTAGj1SvLMWupbignORVFpBfqej5NKihmXCazLP9uoouHMbgDeeafR6ASCc1HsxbnUNjnF8EOvpwgvxTLbtIQkHIwxOxnGYjdw5U4VFrtBot3/YQGfZ4JIKLbenRYy1s5yEzWNTsyFegCRYMQ3g8Wux2TLxueZYOTt7IbCyDPGoQYHxftMyBV/OplIpLh7tQ93+yCeR2MAVJ0owmzTUXHYRk6+WiQRlXR3jjLq+8bXQJiWy3uxFRlRa5QAonxnaQHXOo6ICt3tg1KSxfkoi/NRAN70TNB8qZzGcyXMBCJU1BSKUZPJFGNDC/T3BjYqAZDJoNS1jT2VVgCsDiNWhxGA77PLFFh0TH1Z4v7tAUlNBP4+Z3ILNJy9vl9y4b13mhcPPpNOp7n1sJ4du/LQ6VUsR+JibAlJJBTD+2ycn+E4ZquOA3XbUaoFQj9+AdD72E+WWkFsJSFJQACGgRqA1XiKbvcnAAw5WZRUWlAqxQbS+8TPJvgoa63u2uoHXI8VoFkAeoBTwEXgIFsbBfcAz29MKbQRi6nBoAAAAABJRU5ErkJggg=='
    public static function returnSlackProject($jiraKey, $stlAry)
    {
        $re = '/[a-zA-Z]+/m';
        preg_match_all($re, $jiraKey, $matches, PREG_SET_ORDER, 0);
        $key = $matches[0][0];
        if(array_key_exists($key, $stlAry) && isset($stlAry[$key][3]) && isset($stlAry[$key][4])) {
            return "<a href='https://twitch.slack.com/app_redirect?team=T0266V6GF&channel=" . $stlAry[$key][4] . "' title='" . $stlAry[$key][3] . "'><img class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>";
        } else {
            return "";
        }
    }

    //The function mmmr (Mean, Median, Mode, Range) will calculate the Mean, Median, Mode, or Range of an array. It automatically defaults to Mean (average).
    public static function mmmr($array, $output = 'mean'){
        if(!is_array($array)){
            return FALSE;
        }else{
            switch($output){
                case 'mean':
                    $count = count($array);
                    $sum = array_sum($array);
                    $total = round($sum/$count, 2);
                    break;
                case 'median':
                    sort($array);
                    $middle = floor(count($array)/2);
                    $total = $array[$middle];
                    break;
                case 'mode':
                    $v = array_count_values($array);
                    arsort($v);
                    foreach($v as $k => $v){$total = $k; break;}
                    break;
                case 'range':
                    $total = max($array) - min($array);
                    break;
            }
            return $total;
        }
    }

    /**
     * This user-land implementation follows the implementation quite strictly;
     * it does not attempt to improve the code or algorithm in any way. It will
     * raise a warning if you have fewer than 2 values in your array, just like
     * the extension does (although as an E_USER_WARNING, not E_WARNING).
     *
     * @param array $a
     * @param bool $sample [optional] Defaults to false
     * @return float|bool The standard deviation or false on error.
     */
    public static function stats_standard_deviation(array $a, $sample = false) {
        $n = count($a);
        if ($n === 0) {
            trigger_error("The array has zero elements", E_USER_WARNING);
            return false;
        }
        if ($sample && $n === 1) {
            trigger_error("The array has only 1 element", E_USER_WARNING);
            return false;
        }
        $mean = array_sum($a) / $n;
        $carry = 0.0;
        foreach ($a as $val) {
            $d = ((double) $val) - $mean;
            $carry += $d * $d;
        };
        if ($sample) {
            --$n;
        }
        return sqrt($carry / $n);
    }
}