<?php
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Subscriber\Oauth\Oauth1;

//IT portion has been completed per: https://wiki.twitch.com/display/HD/JIRA+Service+Accounts+-+JIRA+API+and+OAuth
//LDAP/SSO username: srvc-jira-twitchtpm
//Application Link Name: twitchtpm
//Keypair: (Attached)
//Consumer Key: twitchtpm
//Consumer Name: twitchtpm
//Service Account Name: srvc-jira-twitchtpm
//Service Account Owner(s): jonmlee kying kateslau
//Service Explanation: JIRA automation to generate reporting for programs across the company
class Jira {
    protected $jira;
    private $credentials;
    private $credentialsString;

    function __construct()
    {
        $this->credentials = include('../../jira-credentials.php');
        $this->credentialsString = $this->credentials['user'] . ":" . $this->credentials['password'];
    }

    //test GET call with guzzle library
    public function getTestCall()
    {
        $stack = HandlerStack::create();

        $middleware = new Oauth1([
            'consumer_key'    => 'twitchtpm',
            'consumer_secret' => '',
            'token' => $oauthToken,
            'token_secret' => $oauthTokenSecret,
            'private_key_file' => '../../privkey.pem',
            'private_key_passphrase' => '',
            'signature_method' => Oauth1::SIGNATURE_METHOD_RSA,
        ]);https://jira.xarth.tv
        $stack->push($middleware);

        $client = new Client([
            'base_uri' => 'https://jira.xarth.tv/rest/api/2/',
            'handler' => $stack,
            'auth' => 'oauth'
        ]);

        $response = $client->get('field');
        dd($response->getBody()->getContents());
    }

    //test POST call with guzzle library
    public function postTestCall()
    {
        $stack = HandlerStack::create();

        $middleware = new Oauth1([
            'consumer_key'    => 'twitchtpm',
            'consumer_secret' => '',
            'token' => $oauthToken,
            'token_secret' => $oauthTokenSecret,
            'private_key_file' => '../../privkey.pem',
            'private_key_passphrase' => '',
            'signature_method' => Oauth1::SIGNATURE_METHOD_RSA,
        ]);
        $stack->push($middleware);

        $client = new Client([
            'base_uri' => 'https://jira.xarth.tv/rest/api/2/',
            'handler' => $stack,
            'auth' => 'oauth'
        ]);

        $jql = Config::get('ce.jira.jql');
        $response = $client->post('search', [
            'body' => $jql,
            'headers' => [
                'Content-Type' => 'application/json'
            ]
        ]);
        dd($response->getBody()->getContents());
    }

    //test GET call with guzzle library
    public function get($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, $path)
    {
        $stack = HandlerStack::create();

        $middleware = new Oauth1([
            'consumer_key'    => $consumerKey,
            'consumer_secret' => '',
            'token' => $oauthToken,
            'token_secret' => $oauthTokenSecret,
            'private_key_file' => '../../privkey.pem',
            'private_key_passphrase' => '',
            'signature_method' => Oauth1::SIGNATURE_METHOD_RSA,
        ]);

        $stack->push($middleware);

        $client = new Client([
            'base_uri' => $baseURI,
            'handler' => $stack,
            'path' => $path,
            'query' => '',
            'auth' => 'oauth'
        ]);

        $response = $client->request("GET", $path,
            ['headers' => [
                'Content-Type' => 'application/json']
        ]);

        return ($response->getBody()->getContents());
    }


    /* for POSTS */
    public function post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, $path, $data) {
        $stack = HandlerStack::create();

        $middleware = new Oauth1([
            'consumer_key'    => $consumerKey,
            'consumer_secret' => '',
            'token' => $oauthToken,
            'token_secret' => $oauthTokenSecret,
            'private_key_file' => '../../privkey.pem',
            'private_key_passphrase' => '',
            'signature_method' => Oauth1::SIGNATURE_METHOD_RSA,
        ]);

        $stack->push($middleware);

        $client = new Client([
            'base_uri' => $baseURI,
            'handler' => $stack,
            'auth' => 'oauth'
        ]);

        $response = $client->post($path, [
            'body' => $data,
            'headers' => [
                'Content-Type' => 'application/json'
            ]
        ]);
        return ($response->getBody()->getContents());
    }


    //JIRA Dependencies excluding CE JIRA projects
    public static function getDependencies($key, $links) {
        $teams = array();
        $project = "";
        foreach ($links as $link) {

            if (isset($link->outwardIssue)) {
                $re = '/[a-zA-Z]+/';
                preg_match_all($re, $link->outwardIssue->key, $matches, PREG_SET_ORDER, 0);
                $project = $matches[0];
                $project = array_pop($project);
            } elseif (isset($link->inwardIssue)) {
                $re = '/[a-zA-Z]+/';
                preg_match_all($re, $link->inwardIssue->key, $matches, PREG_SET_ORDER, 0);
                $project = $matches[0];
                $project = array_pop($project);
            }

            //our own CE teams shouldn't be a x-team dependency
            if ($project != "CB" && $project != "TCP" && $project != "CE" && $project != "EV") {
                $jql = "issueFunction in linkedIssuesOfRecursive('key = $key') and project = \"" . $project . "\"";
                $teams[$project] = "https://jira.xarth.tv/issues/?jql=" . urldecode($jql);
            }
        }
        return $teams;
    }

    //look through histories + changelog for each issue and only return duedates
    //date, owner, created
    public static function getDueDatesFromJiraChangelogHistory($histories) {
//        dd($histories);
        $temp = array();
        foreach($histories as $history) {
            if (isset($history->items) && $history->items[0]->field == "duedate" && $history->items[0]->to != "") {
//                dd($history);
                $temp[] = array(
                    "due" => $history->items[0]->to,
                    "name" => $history->author->displayName,
                    "date" => $history->created);
            }
        }

        //return only fields that have values
        $temp = array_filter($temp,
            function($var) {
                return !is_null($var) || empty($var);
            });
//        dd($temp);
        return $temp;
    }

    //wrapper for getTimeSpent to determine whether to sum up all stories or just use the epic's state change
    public static function getTimeSpentWrapper($project, $key) {
        if (self::getTimeSpent("story", $project, $key) > 0) {
            //sum up all the state changes for all linked stories
            return self::getTimeSpent("story", $project, $key);
        } else {
            //get the epic state change b/c no stories attached
            return self::getTimeSpent("epic", $project, $key);
        }
    }

    //count time spent excluding weekends and only for working hours
    public static function getTimeSpentForOneStory($histories) {
        $temp = array();
        $time = 0;
        foreach ($histories as $history) {
            if ($history->items[0]->field == "status" || $history->items[0]->field == "resolution") {
                if ($history->items[0]->toString == "In Progress" || (isset($history->items[1]) && $history->items[1]->toString == "Closed") || (isset($history->items[1]) && $history->items[1]->toString == "Done")) {
                    $temp[] = $history->created;
                }
            }
        }
        if (count($temp) > 0) {
            $time = Carbon::parse(max($temp))->diffInHoursFiltered(function(Carbon $date) {
               return $date->isWeekday() && $date->hour >= 8 && $date->hour < 18;
            }, Carbon::parse(min($temp)));
        }
        return $time;
    }

    //look for all stories linked to an epic and then determine time in status between in-progress and closed/done
    //only a rough estimate if things just in and out of state multiple times
    //very slow since it has to grab all epic links and then look through the changelog for each one to determine status state change
    public static function getTimeSpent($type, $project, $key)
    {
        $include = Config::get($project . ".jira.projects");
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
        //loop through stories
        if ($type == "story") {
            $jql = "{
            \"jql\": \"'Epic Link' = $key and resolution in (Done, Closed, Fixed) and project in ($include)\",
            $jqlFragment
            } ";
        } else {
            $jql = "{
            \"jql\": \"'key' = $key and resolution in (Done, Closed, Fixed) and project in ($include)\",
            $jqlFragment
            } ";
        }

        $consumerKey = Config::get($project . '.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "timepsent" . $today . "_" . $project . "_" . $key . "_" . $type;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        //collect all changelog items that have a status or resolution change
        $temp = array();
        foreach ($results->issues as $issue) {
            if ($issue->changelog->total > 0) {
                foreach ($issue->changelog->histories as $history) {
                    if ($history->items[0]->field == "status" || $history->items[0]->field == "resolution") {
                        if ($history->items[0]->toString == "In Progress" || (isset($history->items[1]) && $history->items[1]->toString == "Closed") || (isset($history->items[1]) && $history->items[1]->toString == "Done")) {
//                            $temp[$issue->key][] = $history;
                            $temp[$issue->key][] = $history->created;
                        }
                    }
                }
            }
        }
//        print_r($temp);
        //filter array to items that move into in-progress into closed
        $temp = array_filter($temp,
            function ($var) {
                if (count($var) < 2) {
                    return false;
                } else {
                    return true;
                }
            });

        $time = array(); //collect timespent per ticket
        foreach($temp as $key => $timespent) {
            if(sizeof($timespent) > 2) {
                $timespent[1] = $timespent[2];
                unset($timespent[2]);
            }
            $time[$key] = Carbon::parse($timespent[1])->diffInDays(Carbon::parse($timespent[0]));
        }
//        print_r($time);
        return round(array_sum($time)/7, 1);
    }

    public static function getSprints($sprintAry) {
//        var_dump($sprintAry);
        $re = '/name=([0-9a-z\s\/-]*)/mi';
        foreach($sprintAry as $sprint) {
            preg_match_all($re, $sprint, $matches, PREG_SET_ORDER, 0);
            $sprints[] = $matches[0][1];
        }
        return $sprints;
    }


    public static function getSprintsForLinkedStories($project, $key)
    {
        $include = Config::get($project . ".jira.projects");
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
        //loop through stories
        $jql = "{
        \"jql\": \"'Epic Link' = $key and resolution in (Done, Closed, Fixed) and project in ($include)\",
        $jqlFragment
        } ";

        $consumerKey = Config::get($project . '.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "timepsent" . $today . "_" . $project . "_" . $key;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        //collect all sprints
        $sprints = array();
        $temp = array();
//        dd($results);
        foreach ($results->issues as $issue) {
            if (isset($issue->fields->customfield_10400)) {
                $temp = self::getSprints($issue->fields->customfield_10400);
            }
            $sprints = array_merge($sprints, $temp);
        }
//        sort($sprints);
        return array_unique($sprints);
    }

    public static function getTotalStoryPoints($project, $key)
    {
        $include = Config::get($project . ".jira.projects");
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
        //loop through stories
       $jql = "{
        \"jql\": \"'Epic Link' = $key and resolution in (Done, Closed, Fixed) and project in ($include)\",
        $jqlFragment
        } ";

        $consumerKey = Config::get($project . '.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "timepsent" . $today . "_" . $project . "_" . $key;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        //collect all changelog items that have a status or resolution change
        $temp = array();
        foreach ($results->issues as $issue) {
            if (isset($issue->fields->customfield_10105)) {
               $temp[] = $issue->fields->customfield_10105;
            }
        }
        return array_sum($temp);
    }

    public static function getNumberOfStories($project, $key)
    {
        $include = Config::get($project . ".jira.projects");
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
        //loop through stories
        $jql = "{
        \"jql\": \"'Epic Link' = $key and resolution in (Done, Closed, Fixed) and project in ($include)\",
        $jqlFragment
        } ";

        $consumerKey = Config::get($project . '.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "timepsent" . $today . "_" . $project . "_" . $key;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        return $results->total;
    }

    public static function returnIssuetypeImagePath($issuetype) {
        $paths = array(
            "epic" => "https://i.ibb.co/G5J5f5W/epic.png",
            'task' => "https://i.ibb.co/YRMqSBM/task.png",
            "bug" => "https://i.ibb.co/tqknmLW/bug.png",
            "story" => "https://i.ibb.co/wBqSsvq/story.png",
            "sub-task" => "https://i.ibb.co/wBqSsvq/task.png" //using the same one as tasks
        );
        return $paths[strtolower($issuetype)];
    }
}
