<?php

class Mode {
    protected $jira;
    private $credentials;
    private $credentialsString;

    function __construct()
    {
        $this->credentials = include('../../mode-credentials.php');
        $this->credentialsString = $this->credentials['user'] . ":" . $this->credentials['password'];
    }

    /* for POSTS */
    /**
     * @param $url
     * @param $data
     * @return mixed
     */
    public function post($url, $data) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch,CURLOPT_ENCODING , "");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Authorization: Basic ' . base64_encode("$this->credentialsString"),
                'Content-Type: application/json',
                'Accept: application/hal+json',
                'Content-Length: ' . strlen($data))
        );
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        $res = curl_exec($ch);
        curl_close($ch);
        return($res);
    }

    /* for GETS */
    public function get ($url)
    {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch,CURLOPT_ENCODING , "");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Authorization: Basic ' . base64_encode("$this->credentialsString"),
                'Content-Type: application/json',
                'Accept: application/hal+json')
        );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

        $res = curl_exec($ch);
        curl_close($ch);
        return($res);
    }

    public function getContents ($url) {
        $body = "";
        $opts = array('http' =>
            array(
                'method'  => 'GET',
                'header'  => "Content-Type: application/json\r\n".
                    "X-AUSERNAME: ldapauth_bp\r\n".
                    "Authorization: Basic " . base64_encode($this->credentialsString) . "\r\n",
                'content' => $body,
                'timeout' => 60
            )
        );

        $context  = stream_context_create($opts);
        try {
            $result = file_get_contents($url, false, $context);
            return $result;
        }
        catch(Exception $e) {
            Log::error($e->getMessage());
        }
    }
}