<?php
namespace App\Http\Controllers;
date_default_timezone_set('America/Los_Angeles');

class CounterController extends Controller
{

	/*
	|--------------------------------------------------------------------------
	| Default Home Controller
	|--------------------------------------------------------------------------
	|
	| You may wish to use controllers instead of, or in addition to, Closure
	| based routes. That's great! Here is an example controller method to
	| get you started. To route to this controller, just add the route:
	|
	|	Route::get('/', 'HomeController@showWelcome');
	|
	*/

//	LTD revenue as of 5/13 = $282,276,457.84
//	increment is how fast to increment per second
//	to hit an hour target of $5,689.24/3600 => 3600 seconds
	public function showCount($date = "2015-05-13", $amount = 294275219, $increment= 1000)
	{
		$target = 300000000;
		$difference = $target - $amount;
		$hours = "PT" . round($difference / (3600 * $increment)) . "H";
		$eta = new \DateTime("$date 00:00:00");
		$eta->add(new \DateInterval("$hours"));
//		dd($eta->format("M d, Y"));

		return \View::make('counter',
			array("amount" => $amount,
				"increment" => $increment,
				"eta" => $eta->format("M d, Y")
				)
		);
	}

/*
	https://ops-grafana-01.i.kixeye.com/render?target=alias(shinken.bp-fb-stats.BP_-_Revenue.rolling%2C%20%27Total%27)&from=00:00_20150513&until=00:00_20150514&format=json&maxDataPoints=360
	convert JSON to CSV https://json-csv.com/
	average revenue for the hour
*/

}