<?php
namespace App\Http\Controllers;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;

date_default_timezone_set('America/Los_Angeles');

class Creator extends GenericProject
{
    public function showReport($project = "creator", $subproject ="costream")
    {
//        dd($this->getAllConfigsUnderProgram($project));
//        dd($this->createTemplateData($project));

        $template = Config::get("$project.projectinfo.bladeTemplate");
        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get("$project.projectinfo.name"),
                'summary' => $this->getSummaryFromGoogleSheet($project),
                'data' => $this->createTemplateData($project),
                'stls' => $this->getSTLs($project),
                'contacts' => Config::get("$project.contacts")
            )
        );
    }

    public function sendEmail($type = "test"){
        $project = "creator";
        $template = Config::get("$project.projectinfo.bladeTemplate");
        $data = array(
            'project' => $project,
            'projectName' => Config::get("$project.projectinfo.name"),
            'summary' => $this->getSummaryFromGoogleSheet($project),
            'data' => $this->createTemplateData($project),
            'stls' => $this->getSTLs($project),
            'contacts' => Config::get("$project.contacts")
        );

        //send email
        if ($type == "test") {
            //TEST EMAIL
            $toEmailString = "mlacay@justin.tv,lucerofe@justin.tv,mikaelsi@justin.tv,nguvane@twitch.tv,yucalvi@twitch.tv";
            $bccEmailString = "mlacay@justin.tv,lucerofe@justin.tv,mikaelsi@justin.tv,nguvane@twitch.tv,yucalvi@twitch.tv";
            $toEmails = explode(',', $toEmailString);
            $bccEmails = explode(',', $bccEmailString);

            \Illuminate\Support\Facades\Mail::send($template, $data, function ($message) use ($project, $toEmails, $bccEmails) {
                $emailSubject = env('MAIL_SUBJECT_PREPEND_TEST') . Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->subweeks(1)->format('M j') . " - " . Carbon::today()->endOfWeek()->format('M j') . ")";
                $message->to($toEmails)->bcc($bccEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        } elseif ($type == "final") {
            //FINAL EMAIL
            $toEmailString = "creator-all@twitch.tv";
            $bccEmailString = "creator-interest@twitch.tv";
            $toEmails = explode(',', $toEmailString);
            $bccEmails = explode(',', $bccEmailString);
            \Illuminate\Support\Facades\Mail::send( $template, $data, function ($message) use ($project, $toEmails, $bccEmails) {
                $emailSubject = Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
                $message->to($toEmails)->bcc($bccEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        }

        //show wpu on browser
        return View::make($template, $data);
    }
    public function getAllConfigsUnderProgram($project) {
        $allConfigs = Config::all();
        foreach ($allConfigs[$project] as $key => $value) {
            if (!isset($allConfigs[$project][$key]["projectinfo"])) {
                unset($allConfigs[$project][$key]);
            }
        }
        return $allConfigs[$project];
    }

    //JIRA CUSTOM FIELD NAMES
    //program update JIRA items
    //review date = customfield_15100
    //project status = customfield_17202
    //live date = customfield_13104
    //original deliverable date = customfield_18001
    //product spec = customfield_18201
    //project status summary = customfield_17802
    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    //generic jira GET method using configs
    public function getJiraResults($project = "creator", $subproject = "sunlight", $type = "")
    {
        $jql = 'labels not in (creator-report-exclude) AND ' . Config::get("$project.jira.programJql.jql");
        $jql = preg_replace('/\[\[LABELS\]\]/m',  Config::get("$project.$subproject.jira.roadmapLabel"), $jql); //replace [[LABEL]] with actual fix version
        $jqlFragment = Config::get("$project.jira.jqlFragment");
        $jql = preg_replace('/\[\[JQL\]\]/m', addslashes($jql), $jqlFragment); //form full query for JIRA REST API

        $consumerKey = Config::get("$project.$subproject.jira.consumerKey");
        $baseURI = Config::get( "$project.$subproject.jira.baseURI");
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");

        $today = date("Ymd");
        $modelReflector = new \ReflectionClass(__CLASS__);
        $method = $modelReflector->getMethod(__FUNCTION__)->getName();
        $key = md5($method . $project . $subproject . $jql . $today);

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(EXPIRY);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    public function createTemplateData($project) {
        $data = array();
        foreach ($this->getAllConfigsUnderProgram($project) as $key => $config) {
            $name = $config['projectinfo']['name'];
            $data[$name]['key'] = $key;
            $data[$name]['summary'] = $this->getSummaryFromGoogleSheet($project, $key);
            $data[$name]['jira'] = $this->getJiraResults($project, $key, "fvStories");
        }
        return $data;
    }

    //get STLs from Google Sheets
    public function getSTLs($project) {
        if(Config::get($project . ".projectinfo.stl")) {
            $sheetID = Config::get($project . '.projectinfo.stl.sheetId');
            $sheetRange = Config::get($project . '.projectinfo.stl.sheetRange');
            $stls = \GoogleSheets::getGSheetData($sheetID, $sheetRange, 6); //how many columns of data are there beyond the key?
//            dd($stls);
            return $stls;
        }
    }
}