<?php
namespace App\Http\Controllers;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use phpDocumentor\Reflection\Types\Self_;
use Zend\Log\Writer\Mail;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

//dd(date_default_timezone_get());
//Agile REST API: https://docs.atlassian.com/greenhopper/REST/cloud/
//JIRA REST API: https://docs.atlassian.com/jira/REST/latest/#d2e4004


//Application Link Name: twitchtpm
//Keypair: (Attached)
//Consumer Key: twitchtpm
//Consumer Name: twitchtpm
//Service Account Name: srvc-jira-twitchtpm
class GenericProject extends BaseController
{
    var $project;
    protected $_param;

    public function __construct(Request $request)
    {
//        $$this->project = $request->get("project");
    }

    public function showReport($project = "ce", $subproject ="sunlight")
    {
        $summary = $this->getSummaryFromGoogleSheet($project, $subproject);
        $template = Config::get("$project.$subproject.projectinfo.bladeTemplate");
        $inDev = $this->getJiraResults($project, $subproject, "fvStories");
        $dependencies = $this->getDependencyFromGoogleSheet($project, $subproject);
        if(Config::get("$project.$subproject.burndowns")) {
            $burndowns = Config::get("$project.$subproject.burndowns");
        } else {
            $burndowns = array();
        }

        return View::make($template,
            array(
                'project' => $project,
                'subproject' => $subproject,
                'projectName' => Config::get("$project.$subproject.projectinfo.name"),
                'inDev' => $inDev,
                'summary' => $summary,
                'dependencies' => $dependencies,
                'documents' => Config::get("$project.$subproject.projectinfo.documents"),
                'contacts' => Config::get("$project.contacts"),
                'burndownGraphs' => $burndowns,
                'timeline' => Config::get("$project.$subproject.projectinfo.timeline"),
                'graphJS' => ""
            )
        );
    }

    //get current or last usable content for program update from wpudigests.php or pull it from a google sheet
    public function getSummaryFromGoogleSheet($project, $subproject = ""){
        $Monday = (int)Carbon::today()->startOfWeek()->format('Ymd'); //get Monday and convert to integer
        $Sunday = (int)Carbon::today()->endOfWeek()->format('Ymd'); //get Sunday and convert to integer

        //use googlesheet
        if ($subproject == "") {
            $sheetID = Config::get("$project.projectinfo.exec.sheetId");
            $sheetRange = Config::get("$project.projectinfo.exec.sheetRange");
        } else {
            $sheetID = Config::get("$project.$subproject.projectinfo.exec.sheetId");
            $sheetRange = Config::get("$project.$subproject.projectinfo.exec.sheetRange");
        }
        $digests = \GoogleSheets::getGSheetData($sheetID, $sheetRange);
        $found = 0;
        $weeksAgo = 0;
        while ($found != 1) {
            foreach ($digests as $date => $digest) {
                $date = (int)Carbon::parse($date)->format("Ymd");
                if ($date <= $Sunday && $date >= $Monday) {
                    return $digest;
                }
            }
            $Monday = (int)Carbon::today()->subWeek($weeksAgo)->startOfWeek()->format('Ymd');
            $Sunday = (int)Carbon::today()->subWeek($weeksAgo)->endOfWeek()->format('Ymd');
            $weeksAgo++;
        }
    }

    public function getDependencyFromGoogleSheet($project, $subproject){
        //use googlesheet
        if (Config::get("$project.$subproject.projectinfo.dependency")) {
            $sheetID = Config::get("$project.$subproject.projectinfo.dependency.sheetId");
            $sheetRange = Config::get("$project.$subproject.projectinfo.dependency.sheetRange");
            $dependencies = \GoogleSheets::getRangeData($sheetID, $sheetRange);
//            dd($dependencies);
            return $dependencies;
        } else {
            return array();
        }
    }

    //JIRA CUSTOM FIELD NAMES
    //program update JIRA items
    //review date = customfield_15100
    //project status = customfield_17202
    //live date = customfield_13104
    //original deliverable date = customfield_18001
    //product spec = customfield_18201
    //project status summary = customfield_17802
    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    //generic jira GET method using configs
    public function getJiraResults($project = "ce", $subproject ="sunlight", $type = "fvStories")
    {
        $jql = Config::get("$project.$subproject.jira.$type.jql");
        $jql = preg_replace('/\[\[FVMILESTONE\]\]/m',  Config::get("$project.$subproject.jira.fvmilestone"), $jql); //replace [[FVMILESTONE]] with actual fix version
        $jql = preg_replace('/\[\[PROJECT\]\]/m',  Config::get("$project.$subproject.jira.projects"), $jql); //replace [[PROJECT]] with actual projects
        $jqlFragment = Config::get("$project.$subproject.jira.jqlFragment");
        $jql = preg_replace('/\[\[JQL\]\]/m', addslashes($jql), $jqlFragment); //form full query for JIRA REST API

        $consumerKey = Config::get("$project.$subproject.jira.consumerKey");
        $baseURI = Config::get( "$project.$subproject.jira.baseURI");
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");

        $today = date("Ymd");
        $modelReflector = new \ReflectionClass(__CLASS__);
        $method = $modelReflector->getMethod(__FUNCTION__)->getName();
        $key = md5($method . $project . $subproject . $type . $jql . $jql . $today);

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(EXPIRY);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    public static function getOneIssue($project = "CE", $subproject = "sunlight", $jiraKey = "CB-3464")
    {
        $consumerKey = Config::get("$project.$subproject.jira.consumerKey");
        $baseURI = Config::get( "$project.$subproject.jira.baseURI");
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");

        $today = date("Ymd");
        $modelReflector = new \ReflectionClass(__CLASS__);
        $method = $modelReflector->getMethod(__FUNCTION__)->getName();
        $key = md5($method . $project . $subproject . $jiraKey . $today);

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(EXPIRY);
            $jira = new \Jira();
            $results = json_decode($jira->get($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "issue/$jiraKey"));
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
        return $results->fields;
    }
}
