<?php
namespace App\Http\Controllers;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

/**
 * Class Help
 * @package App\Http\Controllers
 */
class Help extends BaseController
{
    function showRoutes() {
        $app = app();
        $routes = $app->routes->getRoutes();
        $routes = array_filter($routes, function($var) {
            return strstr($var->uri, "twitch");
        });
        $template = "help";
//        dd($routes);
        return View::make($template,
            array(
                'routes' => $routes
            )
        );
    }
}