<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

//Look back at launched items for the current year
class Launched extends BaseController
{

    //create and show WPU page for an individual team
    //default to 'ce' if no key set
    //which team = jira project to filter to
    public function showLaunchedItem($project = "ce", $team = "CB")
    {
        $template = "launched"; //launched.blade.php
        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name') . ": " . strtoupper($team),
                'launched' => $this->getLaunchedItems($project, $team),
                'contacts' => Config::get($project .'.contacts'),
            )
        );
    }

    //jira rest call
    public function getLaunchedItems($project = "ce", $team = "CB")
    {
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
         $jql = "{
            \"jql\": \"((duedate > -12w AND duedate < startOfDay()) or updated > -12w) and project in ($team) and issuetype = Epic and issueFunction in hasLinks('is Epic of') and statusCategory = done ORDER BY due desc\",
            $jqlFragment
            } ";
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("YmdH");
        $key = "launchedreview" . $today . "_" . $project . "_" . $team;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            try {
                $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            }
            catch(RequestException $e) {
                dd("Bad Configuration: ",  $e->getMessage());
            }
            catch (\Exception $e) {
                // There was another exception.
                dd("Bad Configuration: ",  $e->getMessage());
            }
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
//        dd($results->issues[0]->fields->issuelinks);
//        dd($results->issues[5]->changelog->histories);
//        dd($this->getDueDatesFromJiraChangelogHistory($results->issues[0]->changelog->histories));

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array
            ();
        }
    }
}