<?php
namespace App\Http\Controllers;
use App\JiraTicket;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

class PDP extends BaseController
{
    //create pdp update
    public function showPDPItem($project = "pdp")//changed this from ce
    {
        $template = "pdp"; //launched.blade.php --> pdp.blade.php
        $stls = $this->getSTLs($project);
        $launched = $this->getPDPItems($project);
        usort($launched, array($this,"statusCmp"));//format because comp function is in same class
        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name'), //how do I get it to go to the pdp config directory
                'launched' => $launched,
                'newThisWeek' => $this->getNewItems($project),
                'contacts' => Config::get($project .'.contacts'),
                'stls' => $stls,
            )
        );
    }


    public function statusCmp($a, $b){
        //$order = Array("Working Backwards","Design and Feedback", "Design review", "Design Approved", "Build");
        //$ordA = array_search($a->fields->status, $order, true);
        //$ordB = array_search($b->fields->status, $order, true);
        //return $ordA < $ordB;
        $sA = $a->fields->status->name;
        $sB = $b->fields->status->name;

        //is A an earlier status than B?
        if ($sA == "Working Backwards") return true;
        if ($sA == "Design and Feedback" && $sB != "Working Backwards") return true;
        if ($sA == "Design review" && $sB != "Working Backwards" && $sB != "Design and Feedback") return true;
        if ($sA == "Design Approved" && $sB != "Working Backwards" && $sB != "Design and Feedback" && $sB != "Design review") return true;
        return false;

    }

    //send test or final email
    //MAIL_TO_TEST_PDP=justprogrammanagers@justin.tv,jacob@twitch.tv
    //MAIL_TO_PDP=kristen@twitch.tv,jonmlee@twitch.tv
    public function sendPDPEmail($type="test"){
        $project = "pdp";
        $template = "pdp"; //launched.blade.php --> pdp.blade.php
        $stls = $this->getSTLs($project);
        $data = array(
            'project' => $project,
            'projectName' => Config::get($project . '.projectinfo.name'), //how do I get it to go to the pdp config directory
            'launched' => $this->getPDPItems($project),
            'newThisWeek' => $this->getNewItems($project),
            'contacts' => Config::get($project .'.contacts'),
            'stls' => $stls,
            );

        //send email
        if ($type == "test") {
            //TEST EMAIL
            $toEmails = explode(',', env('MAIL_TO_TEST_PDP'));
            \Illuminate\Support\Facades\Mail::send('pdp', $data, function ($message) use ($project, $toEmails) {
                $emailSubject = env('MAIL_SUBJECT_PREPEND_TEST') . Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
                $message->to($toEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        } elseif ($type == "final") {
            //FINAL EMAIL
            $toEmails = explode(',', env('MAIL_TO_PDP'));
            \Illuminate\Support\Facades\Mail::send('pdp', $data, function ($message) use ($project, $toEmails) {
                $emailSubject = Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
                $message->to($toEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        }
        return View::make($template,$data);
    }


    //show shares spaces view
    public function showSharedSpaces($project = "pdp") {
        $template = "sharedspaces"; //launched.blade.php --> pdp.blade.php
        $stls = $this->getSTLs($project);
        $sharedSpaces = Config::get('SharedSpaces.list');

        return View::make($template,
            array(
                'project' => $project,
                'projectName' => "PDP: Shared Spaces",
                'spaces' => $this->getSharedSpaces($project),
                'contacts' => Config::get($project .'.contacts'),
                'stls' => $stls,
                'sharedSpaces' => $sharedSpaces
            )
        );
    }

    //jira rest call for getting PDP Project Plan tickets
    public function getPDPItems($project = "pdp")
    {
        $jql = Config::get($project .'.jira.pdpJQL');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "pdp" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //jira rest call for getting PDP Project Plan tickets
    public function getNewItems($project = "pdp")
    {
        $jql = Config::get($project .'.jira.pdpNewThisWeekJQL');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "pdp2" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }



    //get shared spaces labels and group them
    public function getSharedSpaces($project = "pdp") {
        $jql = Config::get($project .'.jira.sharedSpacesJql');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "sharedspaces" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        foreach($results->issues as $issue) {
            foreach($issue->fields->labels as $label) {
                $temp = new JiraTicket();
                $temp->setKey($issue->key);
                $temp->setSummary($issue->fields->summary);
                $temp->setStatus($issue->fields->status->name);
                if($issue->fields->assignee) {
                    $temp->setAssignee($issue->fields->assignee->displayName);
                } else {
                    $temp->setAssignee("TBD");
                }
                $temp->setProductSpec($issue->fields->customfield_18201);
                $temp->setLabels($issue->fields->labels);
                $labels[$label][] = $temp;
            }
        }
        unset($labels["wpu"]);
        unset($labels["roadmap"]);
        unset($labels["big-rock"]);
//        dd($labels);//debugging
        return $labels;
    }

    //get STLs from Google Sheets
    public function getSTLs($project) {
        if(Config::get($project . ".projectinfo.stl")) {
            $sheetID = Config::get($project . '.projectinfo.stl.sheetId');
            $sheetRange = Config::get($project . '.projectinfo.stl.sheetRange');
            $stls = \GoogleSheets::getGSheetData($sheetID, $sheetRange, 6); //how many columns of data are there beyond the key?
//            dd($stls);
            return $stls;
        }
    }

    //look through histories + changelog for each issue and only return duedates
    //date, owner, created
    public static function getDueDatesFromJiraChangelogHistory($histories) {
//        dd($histories);
        $temp = array();
        foreach($histories as $history) {
            if (isset($history->items) && $history->items[0]->field == "duedate" && $history->items[0]->to != "") {
//                dd($history);
                $temp[] = array(
                    "due" => $history->items[0]->to,
                    "name" => $history->author->displayName,
                    "date" => $history->created);
            }
        }

        //return only fields that have values
        $temp = array_filter($temp,
            function($var) {
                return !is_null($var) || empty($var);
            });
//        dd($temp);
        return $temp;
    }

    //time in current status
    public static function getTimeInStatus($issueAge, $changelog)
    {
        if($changelog->total > 0) {
            $indx = count($changelog->histories);
            while ($indx) {
                $history = $changelog->histories[--$indx];
                if ($history->items[0]->field == "status") {
                    $diff = floor((time() - strtotime($history->created)) / 86400);  // (60 * 60 * 24)
                    return $diff;
                }
            }
        }
        return $issueAge;//return age of ticket if we can't find any status change in the history of the ticket
    }
}