<?php
namespace App\Http\Controllers;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

class Safety extends BaseController
{
    //create VE update
    public function showVEItem($project = "safety")
    {
        $template = "safety";
        $stls = $this->getSTLs($project);
        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name'), //how do I get it to go to the pdp config directory
                'launched' => $this->getLaunchedProjects($project),
                'active' => $this->getActiveProjects($project),
                'external' => $this->getExternalProjects($project),
                'contacts' => Config::get($project .'.contacts'),
                'stls' => $stls,
            )
        );
    }

    //jira rest call for projects in active development
    public function getActiveProjects($project = "safety")
    {
        $jql = Config::get($project .'.jira.safetyJQL');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "launchedreview" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
//        dd($results->issues[0]->fields->issuelinks);
//        dd($results->issues[5]->changelog->histories);
//        $this->getDueDatesFromJiraChangelogHistory($results->issues[0]->changelog->histories);

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //jira rest call for projects launched
    public function getLaunchedProjects($project = "safety")
    {
        $jql = Config::get($project .'.jira.veLaunchedJQL');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "launchedVE" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //jira rest call for projects in active development
    public function getExternalProjects($project = "safety")
    {
        $jql = Config::get($project .'.jira.veExternalJQL');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "externalVE" . $today . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    public static function getPointsProgress($project = "safety",$epicKey){
        //if ($epicKey=='RIP-18') return 'this one';
        if(substr($epicKey,0,3) == 'RIP') return '';
        //call this with the key... so issue --> customfield_11000 should be in the format of MES-xxx epic key.  Assumes it is an epic.
        $jqlFragment = Config::get($project . ".jira.epicPtsJqlFragment");
        $jql = "{
            \"jql\": \"'Epic Link'=$epicKey\",
            $jqlFragment
            } ";
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = Config::get($project . '.jira.oauthToken');
        $oauthTokenSecret = Config::get($project . '.jira.oauthTokenSecret');
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = $epicKey . $today . "_" . $project;//cache for only this epic

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

        if(!isset($results->issues)) {
            return "Pts N/aA";
        }

        // calculate pts done vs not.  resolution, resolutiondate.
        $resolved7Pts = 0;
        $remainPts = 0;
        $day7 = Carbon::now()->subDays(7);
        foreach ($results->issues as $ticket){
            if($ticket->fields->resolution && $ticket->fields->resolution->name == "Done" && Carbon::parse($ticket->fields->resolutiondate)->gt($day7)){
                if (isset($ticket->fields->customfield_10105)){
                    $resolved7Pts += $ticket->fields->customfield_10105;
                }
            }
            elseif ($ticket->fields->resolution == null){
                if(isset($ticket->fields->customfield_10105)){
                    $remainPts += $ticket->fields->customfield_10105;
                }
            }
        }
        //$test = "n/a";
        //if($results->issues[0] && $results->issues[0]->fields)
        //    $test = $results->issues[0]->fields;
        return $resolved7Pts . "pts resolved / " . $remainPts . "pts remain";
    }

    //get STLs from Google Sheets
    public function getSTLs($project) {
        if(Config::get($project . ".projectinfo.stl")) {
            $sheetID = Config::get($project . '.projectinfo.stl.sheetId');
            $sheetRange = Config::get($project . '.projectinfo.stl.sheetRange');
            $stls = \GoogleSheets::getGSheetData($sheetID, $sheetRange, 6); //how many columns of data are there beyond the key?
//            dd($stls);
            return $stls;
        }
    }

    public static function getShortName($fullName){
        $array = explode(" ", $fullName . "");
        if(count($array) >= 2 && $array[1][0]){
            return $array[0] . " " . $array[1][0];
        }
        return $fullName;
    }

    //look through histories + changelog for each issue and only return duedates
    //date, owner, created
    public static function getDueDatesFromJiraChangelogHistory($histories) {
//        dd($histories);
        $temp = array();
        foreach($histories as $history) {
            if (isset($history->items) && $history->items[0]->field == "duedate" && $history->items[0]->to != "") {
//                dd($history);
                $temp[] = array(
                            "due" => $history->items[0]->to,
                            "name" => $history->author->displayName,
                            "date" => $history->created);
            }
        }

        //return only fields that have values
        $temp = array_filter($temp,
            function($var) {
                return !is_null($var) || empty($var);
            });
//        dd($temp);
        return $temp;
    }

    //time in current status
    public static function getTimeInStatus($issueAge, $changelog)
    {
        if($changelog->total > 0)
        {
            $indx = count($changelog->histories);
            while($indx)
            {
                $history = $changelog->histories[--$indx];
                if($history->items[0]->field == "status") {
                    $diff = floor((time() - strtotime($history->created)) / 86400);  // (60 * 60 * 24)
                    return $diff;
                }
            }
            //foreach ($changelog->histories as $history)
            //{
            //    if($history->items[0]->field == "status")
            //    {
            //        $diff = floor((time() - strtotime($history->created)) / 86400);  // (60 * 60 * 24)
            //        return $diff;//($history->created);//break;
            //    }
            //}
        }
        return $issueAge;//return age of ticket if we can't find any status change in the history of the ticket
    }
}